#ifndef _SWAY_STRINGOP_H
#define _SWAY_STRINGOP_H

#include "list.h"

void strip_whitespace(char *str);
char *strip_comments(char *str);
void strip_quotes(char *str);

// strcat that does nothing if dest or src is NULL
char *lenient_strcat(char *dest, const char *src);
char *lenient_strncat(char *dest, const char *src, size_t len);

// strcmp that also handles null pointers.
int lenient_strcmp(char *a, char *b);

// Simply split a string with delims, free with `list_free_items_and_destroy`
list_t *split_string(const char *str, const char *delims);

// Splits an argument string, keeping quotes intact
char **split_args(const char *str, int *argc);
void free_argv(int argc, char **argv);

char *code_strchr(const char *string, char delimiter);
char *code_strstr(const char *haystack, const char *needle);
int unescape_string(char *string);
char *join_args(char **argv, int argc);
char *join_list(list_t *list, char *separator);

/**
 * Add quotes around any argv with whitespaces.
 */
void add_quotes(char **argv, int argc);

// split string into 2 by delim.
char *cmdsep(char **stringp, const char *delim);
// Split string into 2 by delim, handle quotes
char *argsep(char **stringp, const char *delim);

const char *strcasestr(const char *haystack, const char *needle);

#endif
