/**
 * \file item_paste.h
 * \brief Header file for patch item paste routines
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __ITEM_PASTE_H__
#define __ITEM_PASTE_H__

#include "swamidll.h"

/** Status of a patch item paste operation */
typedef enum {
  SWAMIUI_PASTE_NORM,		/* system normal */
  SWAMIUI_PASTE_DUPLICATE,	/* duplicate item found, make a choice */
  SWAMIUI_PASTE_CHANGE,		/* item change (re-check duplicates, etc) */
  SWAMIUI_PASTE_KEEP,		/* keep old duplicate item */
  SWAMIUI_PASTE_CANCEL		/* cancel paste operation */
} SwamiPasteStatus;

SWAMI_API void swamiui_paste_items (IPItem *dstitem, GList *items);
SWAMI_API int swamiui_paste_process (IPItem *dstitem, GList *items,
				     void **handle);
SWAMI_API void swamiui_paste_get_dupinfo (void *handle, IPItem **dupitem,
					  IPItem **dupmatch);
SWAMI_API void swamiui_paste_set_choice (void *handle,
					 SwamiPasteStatus choice);
SWAMI_API void swamiui_paste_set_data (void *handle, gpointer data);
SWAMI_API gpointer swamiui_paste_get_data (void *handle);

#endif
