/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Swac-explore is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _EXPLORER_STATIC_HH
#define _EXPLORER_STATIC_HH

#include <gtkmm/window.h>
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/menu.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/menubar.h>
#include <gtkmm/entry.h>
#include <gtkmm/toolitem.h>
#include <gtkmm/toolbutton.h>
#include <gtkmm/separatortoolitem.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/combobox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/image.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/treemodel.h>

#include "macros.inc"



class ModelListView : public Gtk::TreeModel::ColumnRecord {
public:
	SOUNDS_LIST_VARS;
};

class ModelListBox : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListBox() { 
		add(caption); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
};

class ModelListExt : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListExt() { 
		add(caption); 
		add(value); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
};

class ModelListSoundInfo : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListSoundInfo() { 
		add(caption); 
		add(value); 
		add(weight); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
	Gtk::TreeModelColumn<int> weight;
};


class ExplorerStatic : public Gtk::Window {  
public:
        class Gtk::Entry * entry3;
        class Gtk::ToolItem * toolitem1;

        class Gtk::Image * tool_search_icon;
        class Gtk::ToolItem * tool_search_item;


        class Gtk::SeparatorToolItem * separatortoolitem1;
        class Gtk::ToolButton * toolbutton1;
        class Gtk::SeparatorToolItem * separatortoolitem2;
        class Gtk::ToolItem * toolitem5;
        class Gtk::SeparatorToolItem * separatortoolitem3;
        class Gtk::ToolButton * toolbutton5;
        class Gtk::ToolButton * toolbutton2;
        class Gtk::Toolbar * toolbar1;
        class Gtk::ComboBox * combobox1;
        class Gtk::TreeView * treeview2;
        class Gtk::ScrolledWindow * scrolledwindow2;
        class Gtk::ComboBox * combobox2;
        class Gtk::VBox * vbox2;
        class Gtk::TreeView * treeview1;
        class Gtk::ScrolledWindow * scrolledwindow3;
        class Gtk::TreeView * treeview3;
        class Gtk::ScrolledWindow * scrolledwindow4;
        class Gtk::VPaned * vpaned1;
        class Gtk::HPaned * hpaned1;
        class Gtk::Statusbar * statusbar1;
        class Gtk::VBox * vbox1;

	Glib::RefPtr<Gdk::Pixbuf> icon;

	ModelListView listview;	
	ModelListBox listbox;	
	ModelListExt listext;	
	ModelListSoundInfo listsoundinfo;	

	Glib::RefPtr<Gtk::ListStore> store_sounds;
	Glib::RefPtr<Gtk::ListStore> store_index;
	Glib::RefPtr<Gtk::ListStore> store_lang;
	Glib::RefPtr<Gtk::ListStore> store_fields;
	Glib::RefPtr<Gtk::TreeStore> store_info;

	SOUND_INFO_VARS;

protected:
        ExplorerStatic();
        ~ExplorerStatic();
};

#endif
