# ex:ts=4:sw=4:sts=4:et
# -*- tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*-
from __future__ import absolute_import
import subprocess
import re
import shlex

from svtplay_dl.log import log
from svtplay_dl.utils import is_py2

def download_rtmp(options, url):
    """ Get the stream from RTMP """
    args = []
    if options.live:
        args.append("-v")

    if options.resume:
        args.append("-e")

    extension = re.search(r"(\.[a-z0-9]+)$", url)
    if options.output != "-":
        if not extension:
            options.output = "%s.flv" % options.output
        else:
            options.output = options.output + extension.group(1)
        log.info("Outfile: %s", options.output)
        args += ["-o", options.output]
    if options.silent or options.output == "-":
        args.append("-q")
    if options.other:
        if is_py2:
            args += shlex.split(options.other.encode("utf-8"))
        else:
            args += shlex.split(options.other)

    if options.verbose:
        args.append("-V")

    command = ["rtmpdump", "-r", url] + args
    log.debug("Running: %s", " ".join(command))
    try:
        subprocess.call(command)
    except OSError as e:
        log.error("Could not execute rtmpdump: " + e.strerror)

