/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AOM_AV1_COMMON_MV_H_
#define AOM_AV1_COMMON_MV_H_

#include "EbBlockStructures.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MARK_MV_INVALID(mv) \
    do { ((int_mv *)(mv))->as_int = INVALID_MV; } while (0);
#define CHECK_MV_EQUAL(x, y) (((x).row == (y).row) && ((x).col == (y).col))

typedef union int_mv {
    uint32_t   as_int;
    MV         as_mv;
    FULLPEL_MV as_fullmv;
} int_mv; /* facilitates faster equality tests and copies */

// The mv limit for fullpel mvs
typedef struct {
    int col_min;
    int col_max;
    int row_min;
    int row_max;
} FullMvLimits;

// The mv limit for subpel mvs
typedef struct {
    int col_min;
    int col_max;
    int row_min;
    int row_max;
} SubpelMvLimits;

#endif // AOM_AV1_COMMON_MV_H_
