'''
 ====================================================================
 Copyright (c) 2003-2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_source_control_providers.py

'''
import wb_exceptions

_source_code_providers = {}


def hasProvider( name ):
    return _source_code_providers.has_key( name )

def getProvider( name ):
    return _source_code_providers[ name ]

def registerProvider( provider ):
    _source_code_providers[ provider.name ] = provider

def getProviderAboutStrings():
    about_string = ''
    for provider in _source_code_providers.values():
        about_string += provider.getAboutString()

    return about_string

class Provider:
    def __init__( self, name ):
        self.name = name

    def getProjectInfo( self, app, parent ):
        raise wb_exceptions.InternalError( 'getProjectInfo not implemented' )

    def getProjectTreeItem( self, app, project_info ):
        raise wb_exceptions.InternalError( 'getProjectTreeItem not implemented' )

    def getListHandler( self, app, list_panel, project_info ):
        raise wb_exceptions.InternalError( 'getListHandler not implemented' )

    def getAboutString( self ):
        raise wb_exceptions.InternalError( 'getAboutString not implemented' )

class ProjectInfo:
    def __init__( self, app, parent, provider_name ):
        self.app = app
        self.parent = parent
        self.provider_name = provider_name
        self.project_name = None

    def init( self, project_name, **kws ):
        self.project_name = project_name

    def isChild( self, pi ):
        # return tree if pi is a child of this pi
        raise wb_exceptions.InternalError( 'isChild not implemented' )

    def readPreferences( self, get_option ):
        # load state into a preference file
        raise wb_exceptions.InternalError( 'readPreferences not implemented' )

    def writePreferences( self, set_option ):
        set_option.set( 'provider', self.provider_name )
        set_option.set( 'name', self.project_name )
