/* Copyright (C) 2017 Open Information Security Foundation
 *
 * You can copy, redistribute or modify this Program under the terms of
 * the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/*
 * DO NOT EDIT. This file is automatically generated.
 */

#ifndef __RUST_SNMP_SNMP_GEN_H__
#define __RUST_SNMP_SNMP_GEN_H__

void * rs_snmp_state_new(void);
void rs_snmp_state_free(void * state);
int32_t rs_snmp_parse_request(const Flow * _flow, void * state, void * _pstate, const uint8_t * input, uint32_t input_len, const void * _data, uint8_t _flags);
int32_t rs_snmp_parse_response(const Flow * _flow, void * state, void * _pstate, const uint8_t * input, uint32_t input_len, const void * _data, uint8_t _flags);
void * rs_snmp_state_get_tx(void * state, uint64_t tx_id);
uint64_t rs_snmp_state_get_tx_count(void * state);
void rs_snmp_state_tx_free(void * state, uint64_t tx_id);
int rs_snmp_state_progress_completion_status(uint8_t _direction);
int rs_snmp_tx_get_alstate_progress(void * _tx, uint8_t _direction);
void rs_snmp_tx_set_logged(void * _state, void * tx, uint32_t logged);
uint32_t rs_snmp_tx_get_logged(void * _state, void * tx);
int rs_snmp_state_set_tx_detect_state(void * tx, DetectEngineState * de_state);
DetectEngineState * rs_snmp_state_get_tx_detect_state(void * tx);
AppLayerDecoderEvents * rs_snmp_state_get_events(void * tx);
int8_t rs_snmp_state_get_event_info_by_id(int event_id, const char ** event_name, AppLayerEventType * event_type);
int rs_snmp_state_get_event_info(const char * event_name, int * event_id, AppLayerEventType * event_type);
AppLayerGetTxIterTuple rs_snmp_state_get_tx_iterator(SNMPState * state, uint64_t min_tx_id, uint64_t * istate);
AppLayerGetTxIterTuple rs_snmp_get_tx_iterator(uint8_t _ipproto, AppProto _alproto, void * alstate, uint64_t min_tx_id, uint64_t _max_tx_id, uint64_t * istate);
AppProto rs_snmp_probing_parser(const Flow * _flow, uint8_t _direction, const uint8_t * input, uint32_t input_len, uint8_t * _rdir);
void rs_register_snmp_parser(void);

#endif /* ! __RUST_SNMP_SNMP_GEN_H__ */
