package org.apache.maven.plugin.failsafe.xmlsummary;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import static java.util.Collections.emptyList;
import static org.apache.maven.plugin.failsafe.xmlsummary.ErrorType.FAILURE;
import static org.apache.maven.plugin.failsafe.xmlsummary.ErrorType.NO_TESTS;


/**
 * <p>Java class for anonymous complex type.
 * <p/>
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p/>
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="completed" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="errors" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="failures" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="skipped" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="failureMessage" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *       &lt;/sequence>
 *       &lt;attribute name="result" type="{}errorType" />
 *       &lt;attribute name="timeout" use="required" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType( XmlAccessType.FIELD )
@XmlType( name = "", propOrder = {
                                         "completed",
                                         "errors",
                                         "failures",
                                         "skipped",
                                         "failureMessage"
} )
@XmlRootElement( name = "failsafe-summary" )
public class FailsafeSummary
{
    private static final String ERROR_MSG_PREFIX = "org.apache.maven.surefire.booter.SurefireBooterForkException: ";
    private static final Pattern STACK_TRACE_ELEMENT1 = Pattern.compile( "^\\tat.*\\(.*\\.java\\:[\\d]+\\)$" );
    private static final Pattern STACK_TRACE_ELEMENT2 = Pattern.compile( "^\\tat.*\\(Native Method\\)$" );
    private static final Pattern STACK_TRACE_ELEMENT3 = Pattern.compile( "^Caused by\\: .*" );

    private int completed;

    private int errors;

    private int failures;

    private int skipped;

    @XmlElement( required = true, nillable = true )
    private String failureMessage;

    @XmlAttribute( name = "result" )
    private ErrorType result;

    @XmlAttribute( name = "timeout", required = true )
    private boolean timeout;

    /**
     * Gets the value of the completed property.
     */
    public int getCompleted()
    {
        return completed;
    }

    /**
     * Sets the value of the completed property.
     */
    public void setCompleted( int value )
    {
        this.completed = value;
    }

    /**
     * Gets the value of the errors property.
     */
    public int getErrors()
    {
        return errors;
    }

    /**
     * Sets the value of the errors property.
     */
    public void setErrors( int value )
    {
        this.errors = value;
    }

    /**
     * Gets the value of the failures property.
     */
    public int getFailures()
    {
        return failures;
    }

    /**
     * Sets the value of the failures property.
     */
    public void setFailures( int value )
    {
        this.failures = value;
    }

    /**
     * Gets the value of the skipped property.
     */
    public int getSkipped()
    {
        return skipped;
    }

    /**
     * Sets the value of the skipped property.
     */
    public void setSkipped( int value )
    {
        this.skipped = value;
    }

    /**
     * Gets the value of the failureMessage property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getFailureMessage()
    {
        return failureMessage;
    }

    /**
     * Sets the value of the failureMessage property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setFailureMessage( String value )
    {
        this.failureMessage = value;
    }

    /**
     * Gets the value of the result property.
     *
     * @return possible object is
     * {@link ErrorType }
     */
    public ErrorType getResult()
    {
        return result;
    }

    /**
     * Sets the value of the result property.
     *
     * @param value allowed object is
     *              {@link ErrorType }
     */
    public void setResult( ErrorType value )
    {
        this.result = value;
    }

    /**
     * Gets the value of the timeout property.
     */
    public boolean isTimeout()
    {
        return timeout;
    }

    /**
     * Sets the value of the timeout property.
     */
    public void setTimeout( boolean value )
    {
        this.timeout = value;
    }

    public boolean hasNoTests()
    {
        return getResult() == NO_TESTS;
    }

    public boolean isFailure()
    {
        return getResult() == FAILURE;
    }

    public List<String> extractExceptionMessageLines() throws IOException
    {
        if ( getFailureMessage() == null )
        {
            return emptyList();
        }

        List<String> msg = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader( new StringReader( getFailureMessage() ) );
        for ( @SuppressWarnings( "checkstyle:innerassignment" ) String line; ( line = reader.readLine() ) != null; )
        {
            if ( !STACK_TRACE_ELEMENT1.matcher( line ).matches()
                         && !STACK_TRACE_ELEMENT2.matcher( line ).matches()
                         && !STACK_TRACE_ELEMENT3.matcher( line ).matches() )
            {
                line = line.trim();
                msg.add( line.startsWith( ERROR_MSG_PREFIX ) ? line.substring( ERROR_MSG_PREFIX.length() ) : line );
            }
            else
            {
                break;
            }
        }
        return msg;
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }

        if ( o == null || getClass() != o.getClass() )
        {
            return false;
        }

        FailsafeSummary summary = (FailsafeSummary) o;

        return getCompleted() == summary.getCompleted()
                       && getErrors() == summary.getErrors()
                       && getFailures() == summary.getFailures()
                       && getSkipped() == summary.getSkipped()
                       && isTimeout() == summary.isTimeout()
                       && equal( getFailureMessage(), summary.getFailureMessage() )
                       && getResult() == summary.getResult();
    }

    @Override
    public int hashCode()
    {
        int result1 = getCompleted();
        result1 = 31 * result1 + getErrors();
        result1 = 31 * result1 + getFailures();
        result1 = 31 * result1 + getSkipped();
        result1 = 31 * result1 + ( getFailureMessage() != null ? getFailureMessage().hashCode() : 0 );
        result1 = 31 * result1 + ( getResult() != null ? getResult().hashCode() : 0 );
        result1 = 31 * result1 + ( isTimeout() ? 1 : 0 );
        return result1;
    }

    private boolean equal( String s1, String s2 )
    {
        return s1 == null ? s2 == null : s1.equals( s2 );
    }
}
