package org.apache.maven.plugin.failsafe.xmlsummary;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for errorType.
 * <p/>
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p/>
 * <pre>
 * &lt;simpleType name="errorType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="255"/>
 *     &lt;enumeration value="254"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 */
@XmlType( name = "errorType" )
@XmlEnum( Integer.class )
public enum ErrorType
{

    @XmlEnumValue( "255" )
    FAILURE( 255 ),

    @XmlEnumValue( "254" )
    NO_TESTS( 254 );

    private final int value;

    ErrorType( int v )
    {
        value = v;
    }

    public static ErrorType fromValue( Integer v )
    {
        if ( v == null )
        {
            return null;
        }

        for ( ErrorType c : ErrorType.values() )
        {
            if ( c.value == v )
            {
                return c;
            }
        }
        throw new IllegalArgumentException( "" + v );
    }

    public int value()
    {
        return value;
    }

}
