/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class UpdateStatisticsConstantAction
extends DDLConstantAction {
    private UUID tableUUID;
    private UUID[] objectUUID;
    private String objectName;
    private boolean forTable;
    private long[] conglomerateNumber;
    private ExecIndexRow[] indexRow;
    private DataValueDescriptor[][] rowBufferArray;
    private DataValueDescriptor[] rowBuffer;
    private DataValueDescriptor[] lastUniqueKey;
    private static final int GROUP_FETCH_SIZE = 16;

    public UpdateStatisticsConstantAction() {
    }

    public UpdateStatisticsConstantAction(boolean bl, String string, UUID uUID, UUID[] uUIDArray, long[] lArray, ExecIndexRow[] execIndexRowArray) {
        this.forTable = bl;
        this.objectName = string;
        this.tableUUID = uUID;
        this.objectUUID = uUIDArray;
        this.conglomerateNumber = lArray;
        this.indexRow = execIndexRowArray;
    }

    public String toString() {
        return "UPDATE STATISTICS FOR " + (this.forTable ? "TABLE" : "INDEX") + " " + this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        GenericScanController genericScanController = null;
        TransactionController transactionController = activation.getTransactionController();
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableUUID);
        dependencyManager.invalidateFor(tableDescriptor, 40, languageConnectionContext);
        for (int i = 0; i < this.conglomerateNumber.length; ++i) {
            int n;
            if (this.conglomerateNumber[i] == -1L) continue;
            int n2 = this.indexRow[i].nColumns() - 1;
            long[] lArray = new long[n2];
            long l = 0L;
            this.initializeRowBuffers(this.indexRow[i]);
            try {
                genericScanController = transactionController.openGroupFetchScan(this.conglomerateNumber[i], false, 0, 6, 1, null, null, 0, null, null, 0);
                boolean bl = true;
                n = 0;
                while ((n = genericScanController.fetchNextGroup(this.rowBufferArray, null)) > 0) {
                    for (int j = 0; j < n; ++j) {
                        int n3 = this.compareWithPrevKey(j, bl);
                        bl = false;
                        if (n3 >= 0) {
                            int n4 = n3;
                            while (n4 < lArray.length) {
                                int n5 = n4++;
                                lArray[n5] = lArray[n5] + 1L;
                            }
                        }
                        ++l;
                    }
                    DataValueDescriptor[] dataValueDescriptorArray = this.rowBufferArray[15];
                    this.rowBufferArray[15] = this.lastUniqueKey;
                    this.lastUniqueKey = dataValueDescriptorArray;
                }
            }
            finally {
                if (genericScanController != null) {
                    genericScanController.close();
                    genericScanController = null;
                }
            }
            if (l == 0L) break;
            dataDictionary.dropStatisticsDescriptors(this.tableUUID, this.objectUUID[i], transactionController);
            for (n = 0; n < this.indexRow[i].nColumns() - 1; ++n) {
                StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), this.objectUUID[i], this.tableUUID, "I", new StatisticsImpl(l, lArray[n]), n + 1);
                dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
            }
        }
    }

    private void initializeRowBuffers(ExecIndexRow execIndexRow) {
        this.rowBufferArray = new DataValueDescriptor[16][];
        this.lastUniqueKey = execIndexRow.getRowArrayClone();
        this.rowBufferArray[0] = execIndexRow.getRowArray();
    }

    private int compareWithPrevKey(int n, boolean bl) throws StandardException {
        if (bl) {
            return 0;
        }
        DataValueDescriptor[] dataValueDescriptorArray = n == 0 ? this.lastUniqueKey : this.rowBufferArray[n - 1];
        DataValueDescriptor[] dataValueDescriptorArray2 = this.rowBufferArray[n];
        for (int i = 0; i < dataValueDescriptorArray.length - 1; ++i) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i];
            if (dataValueDescriptor.isNull()) {
                return i;
            }
            if (dataValueDescriptorArray[i].compare(dataValueDescriptorArray2[i]) == 0) continue;
            return i;
        }
        return -1;
    }
}

