function gbtest43
%GBTEST43 test error handling
% All errors generated by this test are expected.

% SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2021, All Rights Reserved.
% SPDX-License-Identifier: GPL-3.0-or-later

rng ('default') ;
ok = true ;
G = GrB (magic (5)) ;

try
    x = prod (G, 'crud') ; %#ok<*NASGU>
    ok = false %#ok<*NOPRT>
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = min (G, [ ], 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = max (G, [ ], 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = min (G, [ ], 1, G) ;
    ok = false ;
catch expected_error
    expected_error
end
assert (ok) ;

try
    x = max (G, [ ], 1, G) ;
    ok = false ;
catch expected_error
    expected_error
end
assert (ok) ;

try
    x = sum (G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = all (G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = any (G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    [x, y] = bandwidth (G, 'lower') ; %#ok<*ASGLU>
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = bandwidth (G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = GrB.eye (1, 2, 3) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    x = GrB.eye ([1, 2, 3]) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G.stuff = 3 ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G (2,1,1) = 3 ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

H = GrB (rand (4,3)) ;
try
    C = H^H ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G^H ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G^(-1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G(1,2).stuff(3,4) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G.stuff ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G (3:4) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = G (1,2,2) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = spones (G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = spones (G, G) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

G = GrB (magic (2), 'int16') ;
try
    C = eps (G)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.entries (G, 'crud')
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.entries (G, 'all', 'degree')
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (G, 0) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (G, 42) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (G, -inf) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (G, 2) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

v = GrB (rand (4,1)) ;
try
    C = norm (G, 42) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = reshape (v, 42, 42) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = reshape (v, [2 2 2]) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = zeros (3, 3, 'like', G, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
end
assert (ok) ;

try
    C = reshape (v, [2 2], 2) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (v, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (v, 3) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = norm (G) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    v = GrB.bfs (v, 1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    v = GrB.bfs (G, 1, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    % G must be symmetric
    v = GrB.bfs (G, 1, 'symmetric', 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    v = [G v] ;     % (concatenate with horzcat)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    v = [G ; v] ;   % (concatenate with vertcat)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.empty (4, 4) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.empty ([0, 4, 4]) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    c = GrB.tricount (v) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    r = GrB.pagerank (rand (3,4)) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

A = magic (5) ;
A (5,1) = 0 ;
G = GrB.prune (A) ;
try
    c = GrB.tricount (G, 'check') ;
    assert (false) ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end

n = 10 ;
A = sprand (n, n, 0.4) ;
S = tril (A, -1) ;
S = S+S' ;
G = GrB (S) ;

try
    L = GrB.laplacian (G, 'uint8') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    L = GrB.laplacian (A, 'double', 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    DiGraph = digraph (GrB (ones (4,3))) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok );

try
    DiGraph = digraph (GrB (ones (4)), 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok );

clear d
d.in0 = 'crud' ;
try
    GrB.descriptorinfo (d) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

clear d
d.in0 = 42 ;
try
    GrB.descriptorinfo (d) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

clear d
d.nthreads = 'something' ;
try
    GrB.descriptorinfo (d) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

clear d
d.chunk = 'something' ;
try
    GrB.descriptorinfo (d) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    E = GrB.incidence (ones (4,3)) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    E = GrB.incidence (ones (4), 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    Graph = graph (GrB (ones (4,3))) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    Graph = graph (GrB (ones (4)), 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.ktruss (rand (4), 2) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = GrB.ktruss (rand (3,4)) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

A = sprand (10, 10, 0.5) ;
try
    C = GrB.ktruss (A, 3, 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

A = A+A' ;
try
    C = GrB.ktruss (A, 3, 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

G = GrB (magic (2)) ;
try
    G = G (2:end)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok)

try
    G = G (2:end, 1:end, 1:end)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok)

try
    iset = GrB.mis (ones (3,4)) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    iset = GrB.mis (ones (3), 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    iset = GrB.mis (ones (3), 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

A = sprand (10, 10, 0.5) ;
try
    iset = GrB.mis (GrB.offdiag (A), 'check') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    iset = GrB.mis (ones (3)) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (A, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (A, 'crud', 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (4, 3, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (4, 3, 'crud', 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (A, A) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (A, A, A) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB (A, A, A, A) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.assign (A, {1}, {1}, {1}, pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.assign (A, '+', '+', {1}, {1}, pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.assign (A, A, A, A) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.assign (A, {1}, {1}) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.semiringinfo ('') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.mxm ('', 1, 1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    c = GrB.reduce (ones (2), '+', '+', 1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.monoidinfo ('/', 'double') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.monoidinfo ('') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.apply ('',1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract (pi, {1}, {1}, {1}) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract (pi, pi, '+', '+', pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract (pi, pi, pi, pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract ('+') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.build (int8(1), int8(1), pi)
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract ('+', pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.select (pi, pi) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract (pi, {1}, {1}, struct ('kind', 'crud')) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.extract (pi, {1}, {1}, struct ('format', 'crud')) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    [i,j,x] = find (G, [3 4]) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    [i,j,x] = find (G, 3, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    [i,j,x] = find (G, -1, 'first') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = flip (G, -1) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    C = flip (G, [2 2]) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.random (10, 10, 0.5, 'crud') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.random (rand (4,5), 'symmetric') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.random (10, 10, 10, 0.5) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.mxm ('to', 'many', 'strings') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.mxm (G, G, G, G, G) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    G = GrB.build (1:3, 1:4, 1:4) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.select ('tril', A) ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    GrB.select (A, A, A, A, 'zero') ;
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

try
    I = GrB.extracttuples (A, struct ('base', 'crud'))
    ok = false ;
catch expected_error
    expected_error
    disp (expected_error.stack (end-1))
end
assert (ok) ;

fprintf ('gbtest43: all tests passed\n') ;

