#include <stdio.h>
#include <string.h>

typedef struct __Tree {
    unsigned char* key;
    
    unsigned int   last;      /* fid, freq buffer μ¥ȥ */
    unsigned int   max;       /* fid, freq buffer Υ */
    unsigned int*  fid;       /* fid buffer */
    int*  freq;      /* եǤνи */
    
    struct __Tree* left;
    struct __Tree* right;
} Tree;

void print_ind0 (Tree* here)
{
    int i;

    if (here->left != NULL) print_ind0(here->left);
    printf("%s %d", here->key, here->last);
    for (i = 0; i < here->last; i++) {
	printf (" %d %d", here->fid[i], here->freq[i]);
    }
    printf ("\n");
    if (here->right != NULL) print_ind0(here->right);
}

void PrintIndex (Tree* here)
{
    if (here->left != NULL) print_ind0(here->left);
    if (here->right != NULL) print_ind0(here->right);
}


Tree* MakeNewTree (unsigned char* key)
{
    Tree* tree;

    tree = (Tree*)malloc(sizeof(Tree));

    tree->key = (unsigned char*)malloc(strlen(key)+1);
    strcpy(tree->key, key);
    tree->last = 0;
    tree->max = 50;
    tree->fid  = (unsigned int*)malloc(sizeof(int)*tree->max);
    tree->freq = (unsigned int*)malloc(sizeof(int)*tree->max);
    tree->left = NULL;
    tree->right = NULL;

    return tree;
}

void AddIndex (Tree* here, int id, unsigned char* key)
{
    unsigned int cr;
    unsigned int max;
    int cmp;

    cmp = strcmp(here->key, key);
    if (cmp == 0) {  /* to be settled here */
	if (here->last >= here->max) {
	    max = here->max * 2;
	    here->fid = (unsigned int*)realloc(here->fid, sizeof(int)*max);
	    here->freq = (unsigned int*)realloc(here->freq, sizeof(int)*max);
	    here->max = max;
	}
	if (here->last >= 1) {
	    cr = here->last - 1;
	    if (here->fid[cr] == id) {
		if (here->freq[cr] < 255) here->freq[cr]++;
	    } else {
		cr = here->last;
		here->fid[cr]  = id; here->freq[cr] = 1;
		here->last++;
	    }
	} else {
	    cr = 0;
	    here->fid[cr]  = id; here->freq[cr] = 1;
	    here->last++;
	}
    } else if (cmp > 0) { /* to be settled left */
	if (here->left == NULL) {
	    here->left = MakeNewTree(key);
	}
	AddIndex(here->left, id, key);
    } else { /* to be settled right */
	if (here->right == NULL) {
	    here->right = MakeNewTree(key);
	}
	AddIndex(here->right, id, key);
    }
}

int main (int argc, char *argv[])
{
    unsigned char BUF[10000], KEY[10000];
    unsigned int id;
    unsigned int last_fid;
    Tree* root;
    unsigned char rootstr[2];
    *rootstr = 0x80; *(rootstr+1) = 0x00;

    root = MakeNewTree(rootstr);
    
    last_fid = 0;
    while ( fgets(BUF, 10000, stdin) != NULL ) {
	sscanf (BUF, "%d %s", &id, KEY);
	if (last_fid > id) {
	    fprintf (stderr, "ERROR: input data seems not to be sorted.\n");
	    exit(1);
	} else if (id > last_fid)
	    last_fid = id;

	AddIndex(root, id, KEY);
    }
    PrintIndex(root);
    fflush(stdout);
    
    exit(0);
}
