/***********************************************************************
  File ID code compresser for IISA
                                    Copyright (C) 1998, Takuya NAKAYAMA
***********************************************************************/
#include <stdio.h>
#include "ix_code.h"

void ix_encode_id (unsigned long val,
		   unsigned char* code, int* len)
{
    unsigned short code2;
    unsigned char  code1;

    if (val < 0xFE) {
	/* 1 byte code */
	code1 = (char)val;
	memcpy(code, &code1, 1);
	*len = 1;
    } else if (val < 0xFFFF) {
	/* 2 byte code */
	*code = 0xFE; code++;
	code2 = (short)val;
	memcpy(code, &code2, 2);
	*len = 3;
    } else { /* 0xFFFF <= diff <= 0xFFFFFFFF */
	/* 4 byte code */
	*code = 0xFF;  code++;
	memcpy(code, &val, 4);
	*len = 5;
    }
}

IxCode ix_encode (IxCodeInfo src)
{
    IxCode ret;
    int i, len;
    unsigned long last_id, id;
    unsigned long  code4;
    unsigned char  code[5];
    char* ptr;
    int bytes;

    bytes = (sizeof(long)+2)*src.num + 10 + src.s_len;
    if ((ret.buf = (char*)malloc(bytes)) == NULL) {
	fprintf (stderr, "memory allocation error\n");
	exit(1);
    }

    ptr = ret.buf;
    /* Ф */
    strncpy(ptr, src.str, src.s_len);
    ptr += strlen(src.str); *ptr = '\0'; ptr++;
    /*  */
    memcpy(ptr, &src.num, sizeof(long));
    ptr += sizeof(long);
    /* File ID and score */
    last_id = 0;
    for (i = 0; i < src.num; i++) {
	/* file ID */
	id = src.files[i] + 1;
	code4 = id - last_id;
	ix_encode_id(code4, code, &len);
	memcpy(ptr, code, len);
	ptr += len;
	last_id = id;
	/* score */
	*ptr = src.score[i];
	ptr++;
    }
    *ptr = '\0';
    ret.len = ptr - ret.buf + 1;
    return ret;
}

IxCodeInfo ix_decode (IxCode src)
{
    IxCodeInfo ret;
    unsigned char* xpt;
    int i;
    unsigned long code4;
    unsigned short code2;
    unsigned long v;

    /* Ф */
    ret.str = src.buf;
    ret.s_len = strlen(ret.str);
    xpt = src.buf + ret.s_len + 1;
    /*  */
    memcpy(&(ret.num), xpt, sizeof(long));
    xpt += sizeof(long);
    /* */
    ret.files = (long*)malloc(sizeof(long) * ret.num);
    ret.score = (char*)malloc(sizeof(char) * ret.num);
    ret.code_rest_len  = 0;
    ret.code_rest = NULL;
    v = -1;
    for (i = 0; i < ret.num; i++) {
	if (i == 1) ret.code_rest = xpt;
	switch (*xpt) {
	  case 0xFF:  /* 4-bytes */
	    xpt++;
	    memcpy(&code4, xpt, 4);
	    v += code4; ret.files[i] = v;
	    xpt += 4;
	    if (i > 0) ret.code_rest_len += 5;
	    break;
	  case 0xFE:  /* 2-bytes */
	    xpt++;
	    memcpy(&code2, xpt, 2);
	    v += code2; ret.files[i] = v;
	    xpt += 2;
	    if (i > 0) ret.code_rest_len += 3;
	    break;
	  default:    /* 1-byte */
	    v += *xpt; ret.files[i] = v;
	    xpt++;
	    if (i > 0) ret.code_rest_len += 1;
	}
	ret.score[i] = *xpt;
	xpt++;
    }
    while (*(xpt++) != '\0');
    ret.code_len = (unsigned long)xpt - (unsigned long)src.buf;

    return ret;
}
