# - Try to find PocketSphinx
# Once done this will define
#  POCKETSPHINX_FOUND - System has PocketSphinx
#  POCKETSPHINX_VERSION - PocketSphinx version
#  POCKETSPHINX_INCLUDE_DIRS - The PocketSphinx include directories
#  POCKETSPHINX_LIBRARIES - The libraries needed to use PocketSphinx
#  POCKETSPHINX_DEFINITIONS - Compiler switches required for using PocketSphinx
#  POCKETSPHINX_MODELDIR - Directory that contains PocketSphinx models

find_package(PkgConfig REQUIRED QUIET)
pkg_check_modules(PC_POCKETSPHINX QUIET pocketsphinx)
set(POCKETSPHINX_DEFINITIONS ${PC_POCKETSPHINX_CFLAGS_OTHER})
set(POCKETSPHINX_VERSION ${PC_POCKETSPHINX_VERSION})

find_path(POCKETSPHINX_INCDIR pocketsphinx.h HINTS ${PC_POCKETSPHINX_INCLUDEDIR} ${PC_POCKETSPHINX_INCLUDE_DIRS})
find_path(SPHINXBASE_INCDIR sphinx_config.h HINTS ${PC_POCKETSPHINX_INCLUDEDIR} ${PC_POCKETSPHINX_INCLUDE_DIRS})
set(POCKETSPHINX_INCLUDE_DIR ${POCKETSPHINX_INCDIR} ${SPHINXBASE_INCDIR})
unset(POCKETSPHINX_INCDIR)
unset(SPHINXBASE_INCDIR)

#find_library(POCKETSPHINX_LIBRARY NAMES pocketsphinx sphinxbase sphinxad HINTS ${PC_POCKETSPHINX_LIBDIR} ${PC_POCKETSPHINX_LIBRARY_DIRS})
set(POCKETSPHINX_LIBRARY ${PC_POCKETSPHINX_LIBRARIES})

set(POCKETSPHINX_LIBRARIES ${POCKETSPHINX_LIBRARY})
set(POCKETSPHINX_INCLUDE_DIRS ${POCKETSPHINX_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments and set POCKETSPHINX_FOUND to TRUE if all listed variables are TRUE
find_package_handle_standard_args(POCKETSPHINX DEFAULT_MSG POCKETSPHINX_LIBRARY POCKETSPHINX_INCLUDE_DIR)

execute_process(COMMAND pkg-config --variable=modeldir pocketsphinx
				OUTPUT_VARIABLE POCKETSPHINX_MODELDIR_OUTPUT
				OUTPUT_STRIP_TRAILING_WHITESPACE)
set(POCKETSPHINX_MODELDIR ${POCKETSPHINX_MODELDIR_OUTPUT})

mark_as_advanced(POCKETSPHINX_INCLUDE_DIR POCKETSPHINX_LIBRARY)
