/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMPARE_H
#define _SC_COMPARE_H

// sc
namespace sc {
  class String;
}

/**
 * a = b =>  0
 * a < b => -1
 * a > b =>  1
 */
template<typename A, typename B> int compare3( const A& a, const B& b )
{
  if( a == b )
  {
    return 0;
  }

  if( a < b )
  {
    return -1;
  }

  // a > b
  return 1;
}

/**
 * compare to sort files/folders in same folder in folder before file order.
 */
int compare3( const sc::String& a, bool aIsDir, const sc::String& b, bool bIsDir );

#endif // _SC_COMPARE_H

