/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "BlameLineLvi.h"
#include "svn/BlameLine.h"
#include "util/Compare.h"



BlameLineLvi::BlameLineLvi( Q3ListView* parent, svn::BlameLinePtr line )
: super(parent), _line(line)
{
}

BlameLineLvi::~BlameLineLvi()
{
}

QString BlameLineLvi::text( int column ) const
{
  switch( column )
  {
  case 0:
    {
      return QString().sprintf( "  %4ld ", (unsigned long)_line->getLineNo() );
    }
  case 1:
    {
      if( _line->getRevnumber() < 0 )
      {
        return QString::null;
      }
      return QString().sprintf( "  %5ld ", (unsigned long)_line->getRevnumber() );
    }
  case 2:
    {
      if( _line->getDate() == 0 )
      {
        return QString::null;
      }
      char time[APR_CTIME_LEN] = {};
      apr_ctime( time, _line->getDate() );
      return time;
    }
  case 3:
    {
      return QString("  %1 ").arg(QString::fromUtf8(_line->getAuthor()));
    }
  case 4:
    {
      return QString("  %1").arg(QString::fromLocal8Bit(_line->getLine()));
    }
  case 5:
    {
      // that is the empty column
      return "";
    }
  default:
    {
      return "invalid column";
    }
  }
}

QString BlameLineLvi::key( int column, bool ascending ) const
{
  return text( column );
}

int BlameLineLvi::compare( Q3ListViewItem * i, int column, bool ascending ) const
{
  svn::BlameLinePtr line = (dynamic_cast<BlameLineLvi*>(i))->_line;

  switch( column )
  {
  case 0:
    {
      return compare3( _line->getLineNo(), line->getLineNo() );
    }
  case 1:
    {
      return compare3( _line->getRevnumber(), line->getRevnumber() );
    }
  case 2:
    {
      return compare3( _line->getDate(), line->getDate() );
    }
  }
  return super::compare(i,column,ascending);
}
