/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "subcommander/WcViewItem.h"
#include "subcommander/wcview/ItemModel.h"
#include "subcommander/wcview/ItemFolder.h"
#include "subcommander/wcview/ItemFinder.h"
#include "subcommander-test/WcViewItemTest.h"
#include "sublib/OStreamQt.h"
#include "util-test/Link.h"
EXPORT_TESTCASE (AnItemFinder);

// gmock
#include <gmock/gmock.h>


namespace wcview
{


class AnItemFinder : public ::testing::Test
{
protected:
  AnItemFinder ()
  {
    _root = createItem("invisible/root",
      WcViewItemTypeDir,WcViewItemStateNormal);
    _fileA = createItem("invisible/root/fileA",
      WcViewItemTypeFile,WcViewItemStateNormal);
    _fileB = createItem("invisible/root/fileB",
      WcViewItemTypeFile,WcViewItemStateNormal);
    _dirC = createItem("invisible/root/dirC",
      WcViewItemTypeDir,WcViewItemStateNormal);
    _fileD = createItem("invisible/root/dirC/fileD",
      WcViewItemTypeFile,WcViewItemStateNormal);
    _fileE = createItem("invisible/root/dirC/fileE",
      WcViewItemTypeFile,WcViewItemStateNormal);
  }

  void SetUp ()
  {
    _items = new ItemFolder (_root,NULL);
    {
      Item* parent = _items;
      Item* item;

      item = new ItemFolder (_fileA,parent);
      parent->insertChild (item);
      item = new ItemFolder (_fileB,parent);
      parent->insertChild (item);
      item = new ItemFolder (_dirC,parent);
      parent->insertChild (item);
      {
        Item* parent = item;

        item = new ItemFolder (_fileD,parent);
        parent->insertChild (item);
        item = new ItemFolder (_fileE,parent);
        parent->insertChild (item);
      }

    }
  }

protected:
  Item*              _items;

  WcViewItemPtr      _root;
  WcViewItemPtr      _fileA;
  WcViewItemPtr      _fileB;
  WcViewItemPtr      _dirC;
  WcViewItemPtr      _fileD;
  WcViewItemPtr      _fileE;
};


TEST_F (AnItemFinder,shouldFindDirectChildren)
{
  ItemFinder finder (_items);
  EXPECT_EQ (_fileA->path(), finder.find (_fileA->path())->getName());
  EXPECT_EQ (_fileB->path(), finder.find (_fileB->path())->getName());
}

TEST_F (AnItemFinder,shouldFindNestedChildren)
{
  ItemFinder finder (_items);
  EXPECT_EQ (_fileD->path(), finder.find (_fileD->path())->getName());
  EXPECT_EQ (_fileE->path(), finder.find (_fileE->path())->getName());
}


#if 0
// Finder....
void AddingItemsToAnItemFolder::shouldFindDirectChildren()
{
  Item* fileA = new ItemFolder (_fileA,_folder);
  Item* fileB = new ItemFolder (_fileB,_folder);
  _folder->insertChild (fileA);
  _folder->insertChild (fileB);

  ItemFinder finder (_folder);
  CPPUNIT_ASSERT_EQUAL (fileA, finder.find (_fileA->path ()));
  CPPUNIT_ASSERT_EQUAL (fileB, finder.find (_fileB->path ()));

  delete fileA;
  delete fileB;
}

void AddingItemsToAnItemFolder::shouldFindNestedChildren ()
{
  Item* dirC  = new ItemFolder (_dirC,_folder);
  Item* fileD = new ItemFolder (_fileD,dirC);
  Item* fileE = new ItemFolder (_fileE,dirC);
  _folder->insertChild (dirC);
  dirC->insertChild (fileD);
  dirC->insertChild (fileE);

  ItemFinder finder (_folder);
  CPPUNIT_ASSERT_EQUAL (fileD, finder.find (_fileD->path ()));
  CPPUNIT_ASSERT_EQUAL (fileE, finder.find (_fileE->path ()));

  delete fileE;
  delete fileD;
  delete dirC;
}

#endif

#if 0
TEST_F (AddingABadItemToAModel,shouldThrowBadItemException)
{
  EXPECT_THROW (_model.insert (_badRootItem), BadItemException );
}
#endif


} // namespace
