/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// test
#include "CompareTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "util/Compare.h"
#include "util/String.h"

/*
test compare method for dir first sorting. This is tricky for flat display.

sc
sc/doc
sc/doc/doxygen
sc/doc/doxygen/doxgen.conf
sc/doc/file
sc/subcommander
sc/subcommander/commands/Cmd.h
sc/subcommander/WcStatusLvi.h
sc/doxgen.conf
sc/sc.ini
*/

void CompareTest::setUp()
{
}

void CompareTest::tearDown()
{
}

void CompareTest::testDirDir()
{
  CPPUNIT_ASSERT_EQUAL( 0, 
    compare3( sc::String("sc/doc"), true, sc::String("sc/doc"), true ) );
  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/doc"), true, sc::String("sc/doc/doxygen"), true ) );
  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/subcommander"), true, sc::String("sc/doc/doxygen"), true ) );
}

void CompareTest::testDirFile()
{
  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/doc"), true, sc::String("sc/conf.txt"), false ) );
  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/doc"), true, sc::String("sc/doxgen.conf"), false ) );

  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/pics"), true, sc::String("sc/doc/doxygen/doxgen.conf"), false ) );

  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/subcommander"), true, sc::String("sc/sc.ini"), false ) );
  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/subcommander/commands"), true, sc::String("sc/sc.ini"), false ) );
  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/subcommander"), true, sc::String("sc/subcommander/BookmarkLvi.h"), false ) );
}

void CompareTest::testFileDir()
{
  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/conf.txt"), false, sc::String("sc/doc"), true ) );
  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/doxgen.conf"), false, sc::String("sc/doc"), true ) );

  CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/doc/doxygen/doxgen.conf"), false, sc::String("sc/pics"), true ) );

  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/sc.ini"), false, sc::String("sc/subcommander"), true ) );
  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/sc.ini"), false, sc::String("sc/subcommander/commands"), true ) );
  CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/subcommander/BookmarkLvi.h"), false, sc::String("sc/subcommander"), true ) );
}

void CompareTest::testFileFile()
{
 CPPUNIT_ASSERT_EQUAL( 0, 
    compare3( sc::String("sc.ini"), false, sc::String("sc.ini"), false ) );

 CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/util/uuid.h"), false, sc::String("sc/util/uuid.cpp"), false ) );
 CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/util/uuid.cpp"), false, sc::String("sc/util/uuid.h"), false ) );

 CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/pics/image.png"), false, sc::String("sc/sc.ini"), false ) );
 CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/sc.ini"), false, sc::String("sc/pics/image.png"), false ) );

 CPPUNIT_ASSERT_EQUAL( 1, 
    compare3( sc::String("sc/c/d/c/d/image.png"), false, sc::String("sc/b/c/sc.ini"), false ) );
 CPPUNIT_ASSERT_EQUAL( -1, 
    compare3( sc::String("sc/b/c/sc.ini"), false, sc::String("sc/c/d/c/d/image.png"), false ) );
}
