/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_WC_STATUS_H
#define _SVN_WC_STATUS_H

// sc
#include "WcStatusTypes.h"
#include "util/String.h"

namespace svn
{
class WcEntry;
class Lock;

/** wc/svn_wc_status2_t */
class WcStatus
{
public:
  WcStatus( const sc::String&, svn_wc_status2_t* );
  WcStatus( const WcStatus& src );
  ~WcStatus();

  void calcLockStatus( bool repos );

  const sc::String& getName() const;
  const sc::String& getUrl() const;

  const WcEntry* getWcEntry() const;
  WcStatusKind getTextStatus() const;
  WcStatusKind getPropStatus() const;
  bool isLocked() const;
  bool isCopied() const;
  bool isSwitched() const;
  WcStatusKind getReposTextStatus() const;
  WcStatusKind getReposPropStatus() const;

  WcStatusLockKind getLockStatus() const;
  const Lock* getReposLock() const;

  bool isChanged() const;
  bool isReposChanged() const;

  bool isChangedOrFlaged() const;  ///< a better name?

  bool isAddable() const;
  bool isRevertable() const;
  bool isRemoveable() const;
  bool isConflicted() const;
  bool isPropConflicted() const;
  bool isVersioned() const;
  bool isIgnored() const;

  // WcEntry
  bool isDir() const;

private:
  sc::String       _name;

  WcEntry*         _entry;
  WcStatusKind     _textStatus;
  WcStatusKind     _propStatus;
  bool             _locked;
  bool             _copied;
  bool             _switched;
  WcStatusKind     _reposTextStatus;
  WcStatusKind     _reposPropStatus;

  WcStatusLockKind _lockStatus;
  Lock*            _reposLock;
};

} // namespace

#endif //  _SVN_WC_STATUS_H

