/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// svn
#include "WcNotify.h"
#include "Lock.h"
#include "Error.h"

namespace svn
{

WcNotify::WcNotify( const svn_wc_notify_t* notify )
: _lock(0), _error(0)
{
  _path      = notify->path;
  _action    = (WcNotifyAction)notify->action;
  _kind      = (NodeKind)notify->kind;
  _mimetype  = notify->mime_type;

  if( notify->lock )
  {
    _lock = new Lock( notify->lock );
  }

  if( notify->err )
  {
    // without duplicating the error we cause a crash by deleting it
    // two times..
    _error = wrapError(svn_error_dup(notify->err));
  }

  _contState = (WcNotifyState)notify->content_state;
  _propState = (WcNotifyState)notify->prop_state;
  _lockState = (WcNotifyLockState)notify->lock_state;
  _revision  = notify->revision;
}

WcNotify::~WcNotify()
{
  delete _error;
  delete _lock;
}

WcNotifyAction WcNotify::getAction() const
{
  return _action;
}

WcNotifyState WcNotify::getStatus() const
{
  return _contState;
}

WcNotifyState WcNotify::getPropStatus() const
{
  return _propState;
}

WcNotifyLockState WcNotify::getLockStatus() const
{
  return _lockState;
}

const sc::Error* WcNotify::getError() const
{
  return _error;
}

const sc::String& WcNotify::getPath() const
{
  return _path;
}

} // namespace
