/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "DiffSummarize.h"


namespace svn
{


DiffSummarize::DiffSummarize( const svn_client_diff_summarize_t* summarize )
{
  if(!summarize)
    return;

  _name        = summarize->path;
  _kind        = (DiffSummarizeKind)summarize->summarize_kind;
  _propChanged = summarize->prop_changed == TRUE;
  _nodeKind    = (NodeKind)summarize->node_kind;
}

DiffSummarize::DiffSummarize( const DiffSummarize& src )
{
  _name = src._name;
}

DiffSummarize::~DiffSummarize()
{
}

const sc::String& DiffSummarize::getName() const
{
  return _name;
}

NodeKind DiffSummarize::getNodeKind() const
{
  return _nodeKind;
}

DiffSummarizeKind DiffSummarize::getKind() const
{
  return _kind;
}

bool DiffSummarize::hasPropChanges() const
{
  return _propChanged;
}

bool DiffSummarize::isDir() const
{
  return _nodeKind == svn::Node_Dir;
}

} // namespace
