/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGMANAGER_H
#define _SC_CONFIGMANAGER_H

//sc
#include "settings/FontSettings.h"
#include "sublib/DebugSettings.h"
#include "sublib/settings/ColorSettings.h"
#include "sublib/settings/LayoutSettings.h"
class ConfigFile;
class ConfigData;


class ConfigManager :
  public FontSettings,
  public ColorSettings,
  public DebugSettings,
  public LayoutSettings
{
public:
  ConfigManager();
  ~ConfigManager();

  void load();
  void save();

  // FontSettings
  QFont getGeneralFont();
  void setGeneralFont( const QFont& );
  QFont getEditorFont();
  void setEditorFont( const QFont& );

  // ColorSettings
  void getColors( Colors& );
  void setColors( const Colors& );

  /**
   * \name DebugSettings.
   */
  // @{
  bool getDump();
  void setDump(bool);
  bool getLog();
  void setLog(bool);
  bool getL10n();
  void setL10n(bool);
  // @}

  /** @name LayoutSettings. */
  // @{
  int  getValue( const QString& key, int def );
  void setValue( const QString& key, int pos );
  QSize getSize( const QString& key, const QSize& def );
  void  setSize( const QString& key, const QSize& rect );
  QRect getRect( const QString& key, const QRect& def );
  void  setRect( const QString& key, const QRect& rect );
  void getHeaderColumns( const QString& key, Q3Header* );
  void setHeaderColumns( const QString& key, const Q3Header* );
  // @}

  /**
   * \name Options.
   */
  // @{
  bool getOptWhitespace() const;
  void setOptWhitespace( bool );
  // @}

private:
  Color getColor( long id, const sc::String& name, const QColor& def, const sc::String& desc );

  ConfigFile* _file;
  ConfigData* _cfg;

private:
  void clean();

  bool _dbgDump;  // DebugSettings, not persistent
};


#endif //  _SC_CONFIGMANAGER_H
