/* ====================================================================
* Copyright (c) 2007,      Martin Hauner
*                          http://subcommander.tigris.org
*
* Subcommander is licensed as described in the file doc/COPYING, which
* you should have received as part of this distribution.
* ====================================================================
*/

#ifndef _SC_LAYOUTSETTINGSHANDLER_H
#define _SC_LAYOUTSETTINGSHANDLER_H

// sc
#include "LayoutSettings.h"
class ConfigData;

// qt
#include <QtCore/QRect>
#include <QtCore/QString>
class Q3Header;

/**
 * @c LayoutSettings support. This class contains methods that handle
 * the details of reading and storing the layout settings.
 */
class LayoutSettingsHandler
{
public:
  /** Get an @c int value for @a key from @a cfg. */
  static int getValue( ConfigData* cfg, const QString& key, int def );
  /** Store @a value under @a key. */
  static void setValue( ConfigData* cfg, const QString& key, int value );

  /** Get the @c QSize for @a key from @a cfg. Return @a def for an unknown @a key. */
  static QSize getSize( ConfigData* cfg, const QString& key, const QSize& def );
  /** Store @a size under @a key in @a cfg. */
  static void setSize( ConfigData* cfg, const QString& key, const QSize& size );

  /** Get the @c QRect for @a key from @a cfg. Returns @a def for an unknown @a key. */
  static QRect getRect( ConfigData* cfg, const QString& key, const QRect& def );
  /** Store @a rect under @a key in @a cfg. */
  static void setRect( ConfigData* cfg, const QString& key, const QRect& rect );

  /** Get @c Q3Header layout (column size and position) for key @c from @a cfg. Does
   * nothing for an unknown @a key */
  static void getHeaderColumns( ConfigData* cfg, const QString& key, Q3Header* header );
  /** Store @c Q3Header layout (column size and position) under @a key in @a cfg. */
  static void setHeaderColumns( ConfigData* cfg, const QString& key, const Q3Header* header );

private:
  LayoutSettingsHandler();
};

#endif // _SC_LAYOUTSETTINGSHANDLER_H
