/* ====================================================================
* Copyright (c) 2003-2007, Martin Hauner
*                          http://subcommander.tigris.org
*
* Subcommander is licensed as described in the file doc/COPYING, which
* you should have received as part of this distribution.
* ====================================================================
*/

#ifndef _SC_LAYOUTSETTINGS_H
#define _SC_LAYOUTSETTINGS_H

// qt
#include <QtCore/QRect>
#include <QtCore/QString>
class QHeaderView;
class Q3Header;

/**
 * Interface for storing layout related information.
 */
class LayoutSettings
{
public:
  virtual ~LayoutSettings(){}

  /** Get an @c int value for @a key. */
  virtual int getValue( const QString& key, int val ) = 0;
  /** Store @a value under @a key. */
  virtual void setValue( const QString& key, int value ) = 0;

  /** Get the @c QSize for @a key. If @a key is unknown return @a def. */
  virtual QSize getSize( const QString& key, const QSize& size ) = 0;
  /** Store @a size under @a key. */
  virtual void setSize( const QString& key, const QSize& size ) = 0;

  /** Get the @c QRect for @a key. If @a key is unknown return @a def. */
  virtual QRect getRect( const QString& key, const QRect& def ) = 0;
  /** Store @a rect under @a key. */
  virtual void  setRect( const QString& key, const QRect& rect ) = 0;

  /** @obsolete Set QHeader layout (column size and position) for @a key. */
  virtual void getHeaderColumns( const QString& key, Q3Header* ) = 0;
  /** @obsolete Store QHeader layout (column size and position) under @a key. */
  virtual void setHeaderColumns( const QString& key, const Q3Header* ) = 0;

#if 0
  /** Set the column information in @c QHeaderView for @a key. */
  virtual void getHeaderColumns( const QString& key, QHeaderView* ) = 0;
  /** Store the column information of @c QHeader as @a key. */
  virtual void setHeaderColumns( const QString& key, const QHeaderView* ) = 0;
#endif
};

#endif // _SC_LAYOUTSETTINGS_H
