/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _DIFF3WIDGET_H
#define _DIFF3WIDGET_H

// sc
#include "util/String.h"
class TextModel;
class DiffInfoModel;
class SingleTextWidget;
class DoubleTextWidget;
class SplitLayout;
class FontSettings;

// qt
#include <qwidget.h>
#include <qsplitter.h>


class Diff3Widget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  Diff3Widget( FontSettings*, QWidget *parent=0, const char *name=0 );
  virtual ~Diff3Widget();

  void setModel( TextModel* original, TextModel* modified, TextModel* latest );
  void setModel( DiffInfoModel* info );
  void setMergeModel( TextModel* merged );

  void setLeftLabel( const sc::String& l );
  void setCenterLabel( const sc::String& l );
  void setRightLabel( const sc::String& l );

  void jumpToLine( int line );
  void jumpToBlock( int block );
  void setActiveDiff( int num );

  void enableOriginal( bool enable = true, bool open = false );
  void enableMerged( bool enable = true, bool open = false );

  void connectOriginalDrop( const QObject* receiver, const char* member );
  void connectModifiedDrop( const QObject* receiver, const char* member );
  void connectLatestDrop( const QObject* receiver, const char* member );

public slots:
  void vsbChange(int);
  void hsbChange();

  void blockChangeO(int b);
  void blockChangeL(int b);
  void blockChangeR(int b);
  void blockChangeM(int b);

signals:
  void diffChanged(int diff);

protected:
  void wheelEvent( QWheelEvent* e );

private:
  void setActiveDiffBlock( int block );

  SingleTextWidget*  _single;
  DoubleTextWidget*  _double;
  SingleTextWidget*  _merged;

  SplitLayout*       _splitOrg;
  SplitLayout*       _splitMerge;

  DiffInfoModel*     _diffInfo;
};


#endif // _DIFF3WIDGET_H

