/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTPARAM_H
#define _SC_LISTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/DirEntryTypes.h"

/**
 * Parameter class for ListCmd.
 */
class ListParam : public ScParam
{
public:
  ListParam( const sc::String& pathOrUrl, const svn::Revision* rev, bool recurse,
    bool refresh )
    : _pathOrUrl(pathOrUrl), _rev(rev), _recurse(recurse), _refresh(refresh)
  {
  }

  ~ListParam()
  {
    delete _rev;
  }

  const sc::String getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getRefresh() const
  {
    return _refresh;
  }

  svn::DirEntries& getEntries()
  {
    return _entries;
  }

  ScParamAccept(ListParam);

private:
  // in
  sc::String           _pathOrUrl;
  const svn::Revision* _rev;
  bool                 _recurse;
  bool                 _refresh;

  // out
  svn::DirEntries      _entries;
};

#endif // _SC_LISTPARAM_H
