/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTITEM_DRAGOBJECT_H
#define _SC_PROJECTITEM_DRAGOBJECT_H

// sc
#include "util/uuid.h"

// qt
#include <qdragobject.h>


class ProjectItem
{
public:
  ProjectItem()
    : _prjId(Uuid::createEmpty()), _itemId(0)
  {
  }

  ProjectItem( const Uuid& prjId, long itemId )
    : _prjId(prjId), _itemId(itemId)
  {
  }

  Uuid _prjId;
  long _itemId;
};


class ProjectItemDragObject : public QStoredDrag
{
public:
  ProjectItemDragObject( const char* mimeType, QWidget* dragSource,
    const ProjectItem& prjItem )
    : QStoredDrag( mimeType, dragSource )
  {
    QString data;
    data += prjItem._prjId.toString();
    data += "|";
    data += QString("%1").arg(prjItem._itemId);

    QByteArray* dataArr = new QByteArray;
    dataArr->assign( data, data.length() );
    setEncodedData(*dataArr);
  }

  static bool decode( const QMimeSource* e, ProjectItem& prjItem )
  {
    QByteArray dataArr = e->encodedData(e->format());
    QString data(dataArr);
    QString prjId  = data.section( "|", 0, 0 );
    QString itemId = data.section( "|", 1, 1 );
    prjItem._prjId  = Uuid(prjId);
    prjItem._itemId = itemId.toLong();
    return true;
  }
};


#endif // _SC_PROJECTITEM_DRAGOBJECT_H
