/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [prim.h]         Instance functions for simple data types                */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef prim_INCL
#define prim_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ----------- Pre-defined functions for various data types --------------- */

long bytesHash(c_byte x[], long len);  /* hash function for byte sequences  */
long strHash(c_string s);              /* hash function for type "string"   */
c_bool strEqual(c_string a, c_string b); /* whether 'a' and 'b' are equal   */

long combineOrderedHash(long a, long b)
/* combination of two non-commuative hash values */
;

long combineCommutativeHash(long a, long b)
/* combination of two permutable hash values */
;


/* ----------- Pre-defined functions for primitive data types --------------- */

long primHash(StdCPtr x)
/* hash function for primitive types like "char","int","pointer" */
;

c_bool  primEqual(StdCPtr a, StdCPtr b);   /* whether 'a' and 'b' are equal */

c_bool primGreatEqual(StdCPtr a, StdCPtr b)
/* whether 'a' is greater equal than 'b' */
;

c_bool primLessEqual(StdCPtr a, StdCPtr b)
/* whether 'a' is less equal than 'b' */
;

int     primCompare(StdCPtr a, StdCPtr b); /* order of 'a' and 'b'          */
StdCPtr primCopy(StdCPtr a);               /* identity                      */
void primFree(StdCPtr a);     /* frees a primitive value; i.e. does nothing */


#ifdef __cplusplus
}
#endif

#endif
