// Create layers for the different images we are using
// The layers will be drawn in the order in which they 
// were created - we can change their properties later.

//lBG = defineLayer("bg.png");

letterSpacing = 0.7;
maxHeight = 50;
maxWidth = 100;
glowCol = getColor("Background", 0.6, 0.7, 1.);
numCol = getColor("Numbers", 0., 0., 0.);

var timeString = "";
if (hour<10) timeString = "0";
h = hour; // TODO: am/pm stuff
timeString = timeString + h.toString() + ":";
if (minute<10) timeString = timeString + "0";
timeString = timeString + minute.toString();
if (showSeconds) {
	timeString = timeString + ":";
	if (second < 10) timeString = timeString + "0";
	timeString = timeString + second.toString();
}

var numProps = new Array();
function defineNumPos(s,x,y,w,h) {
	o = new Object();
	o.texX = x/128.0; o.texY = y/128.0; o.texW = w/128.0; o.texH = h/128.0;
	numProps[s] = o;
}
// the use font is a proportional font, but we used equidistant 
// char widths for the numbers, since the graphic would jump around
// with different widths for each number.
defineNumPos("0", 0, 0, 29, 40);
defineNumPos("1", 29, 0, 29, 40);
defineNumPos("2", 55, 0, 29, 40);
defineNumPos("3", 86, 0, 29, 40);
defineNumPos("4", 0, 41, 29, 40);
defineNumPos("5", 29, 41, 29, 40);
defineNumPos("6", 58, 41, 29, 40);
defineNumPos("7", 89, 41, 29, 40);
defineNumPos("8", 0, 86, 29, 40);
defineNumPos("9", 30, 86, 29, 40);
defineNumPos(":", 62, 86, 20, 40);
defineNumPos(".", 82, 86, 18, 40);
defineNumPos("/", 100, 86, 28, 40);

stringWidth = 0;
for (n=0; n<timeString.length; ++n) {
	stringWidth = stringWidth + letterSpacing*numProps[timeString[n]].texW;
}

stringWidth = stringWidth + (1-letterSpacing) * 
	numProps[timeString[timeString.length-1]].texW;

stringHeight = 0;
for (n=0; n<timeString.length; ++n) {
	stringHeight = Math.max(stringHeight, numProps[timeString[n]].texH);
}

scaleX = Math.min(Math.min(maxWidth, screenWidth) / stringWidth,
	Math.min(maxHeight, screenHeight) / stringHeight );
scaleY = scaleX;
//scaleX = screenWidth/stringWidth;
//scaleY = screenHeight/stringHeight;
//scaleX = 128;
//scaleY = 128;

xPos = 0;
for (n=0; n<timeString.length; ++n) {
	numProp = numProps[timeString[n]];
	glow = defineLayer("glow.png");
	num = defineLayer("numbers.png");
	glow.texX = numProp.texX; glow.texY = numProp.texY;
	glow.texW = numProp.texW; glow.texH = numProp.texH;
	num.texX = numProp.texX; num.texY = numProp.texY;
	num.texW = numProp.texW; num.texH = numProp.texH;
	glow.moveX = num.moveX = xPos;
	glow.moveY = num.moveY = (screenHeight-(scaleY*stringHeight))/2;
	glow.scaleX = num.scaleX = scaleX*num.texW; 
        glow.scaleY = num.scaleY = scaleY*num.texH;
	xPos = xPos + num.texW*scaleX*letterSpacing;	
	num.color.r = numCol.r;
	num.color.g = numCol.g;
	num.color.b = numCol.b;
        glow.color.r = glowCol.r;
        glow.color.g = glowCol.g;
        glow.color.b = glowCol.b;
}

function widthForHeight(height) {
	return Math.min(maxWidth, Math.min(height,
		maxHeight)*stringWidth/stringHeight);
}

function heightForWidth(width) {
	return Math.min(maxHeight, Math.min(width,
		maxWidth)*stringHeight/stringWidth);
}