#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xE5, 0x09, 0xEB, 0x6B, 0x7E, 0xFF, 0x06, 0x2E, 0xE9, 0x8E, 
	0xEB, 0xB8, 0x15, 0x2E, 0x83, 0xE9, 0x77, 0x6B, 0x98, 0x80, 
	0xC2, 0x5B, 0xC7, 0x99, 0xEF, 0xD2, 0x3B, 0x75, 0x23, 0xD1, 
	0xEF, 0x4D, 0x2C, 0xE6, 0xE5, 0xD3, 0x6A, 0x5E, 0x38, 0x4A, 
	0x05, 0x15, 0x57, 0xFF, 0x46, 0x22, 0x0F, 0xDC, 0xC9, 0xF0, 
	0xA0, 0x4C, 0x2B, 0x70, 0x91, 0x30, 0x32, 0x3A, 0x20, 0x38, 
	0xB6, 0x62, 0xAE, 0x8C, 0x9E, 0x9B, 0x7A, 0x04, 0xCF, 0x9C, 
	0x20, 0x0C, 0x9D, 0x34, 0xFC, 0xB5, 0x46, 0x9E, 0xB6, 0x56, 
	0x94, 0x7A, 0x8E, 0x7B, 0xEA, 0x77, 0x3D, 0x1F, 0x57, 0xAD, 
	0xB0, 0xB7, 0xD6, 0x2E, 0x95, 0x5B, 0xA7, 0x1E, 0xF1, 0x84, 
	0x04, 0x7C, 0x77, 0x9B, 0x10, 0x8D, 0x5F, 0xA5, 0x2B, 0x0D, 
	0xCB, 0xFB, 0xB9, 0x0A, 0xCB, 0xDD, 0x70, 0x9F, 0x85, 0xBA, 
	0xE3, 0x6A, 0xD1, 0xE4, 0x83, 0x7B, 0x89, 0x66, 0xAC, 0x58, 
	0x12, 0x43, 0x5B, 0xA8, 0x02, 0xC0, 0x5C, 0x27, 0x61, 0x97, 
	0x5D, 0xEC, 0x94, 0x71, 0xB2, 0x13, 0x13, 0xAB, 0x30, 0x0C, 
	0x54, 0x54, 0x8C, 0xE2, 0x9D, 0x07, 0xDE, 0xE7, 0x62, 0x70, 
	0xDE, 0x6C, 0x48, 0xD7, 0x69, 0xDA, 0xBC, 0xDA, 0xB1, 0x82, 
	0xE4, 0xD7, 0xE4, 0xFB, 0x6D, 0x36, 0x46, 0x55, 0x30, 0x63, 
	0x18, 0x42, 0x82, 0x60, 0xE2, 0x76, 0x23, 0x56, 0x34, 0x25, 
	0xA9, 0x6A, 0xF1, 0x06, 0xB1, 0x68, 0xAD, 0x7F, 0xCE, 0x06, 
	0xEE, 0x85, 0xA5, 0x83, 0x85, 0x08, 0x45, 0x45, 0x09, 0xA7, 
	0x3D, 0xC9, 0xAC, 0xE6, 0x3A, 0x98, 0x93, 0xBF, 0x98, 0x2E, 
	0x4D, 0x00, 0x3B, 0x74, 0x62, 0x7B, 0x8D, 0xBD, 0x18, 0x6C, 
	0xAC, 0x4B, 0xEF, 0xF5, 0xAD, 0x0E, 0x2E, 0x85, 0x60, 0xE6, 
	0xF4, 0x3F, 0x25, 0xFE, 0xAE, 0xC3, 0x18, 0x9B, 0x04, 0x7B, 
	0xC7, 0x48, 0xE8, 0xC1, 0x3C, 0x13
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
