#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xC0, 0x50, 0xCE, 0xC1, 0x07, 0x9C, 0x22, 0x35, 0x2D, 0x84, 
	0x78, 0xD7, 0xC2, 0xD4, 0x5B, 0x46, 0xFF, 0xD9, 0x92, 0xF8, 
	0x5A, 0x72, 0x06, 0x5A, 0x1E, 0xC0, 0xC4, 0x73, 0x4E, 0xE1, 
	0xF5, 0x50, 0x2F, 0x94, 0xAA, 0x92, 0x89, 0x9E, 0x09, 0xB0, 
	0x08, 0x37, 0xC8, 0x58, 0x7C, 0xA6, 0x6A, 0x4B, 0x8F, 0xF7, 
	0x3E, 0xA1, 0x91, 0x64, 0x3D, 0xFC, 0xB7, 0xC3, 0xEA, 0x67, 
	0x7B, 0x99, 0xFC, 0x1E, 0x71, 0xCA, 0x0E, 0x48, 0x48, 0x42, 
	0x32, 0x37, 0x86, 0x8E, 0x35, 0xED, 0xD2, 0x35, 0xA9, 0xBF, 
	0x17, 0x5C, 0x75, 0x97, 0x03, 0xDD, 0xB0, 0xDF, 0x65, 0x28, 
	0x63, 0x81, 0x3B, 0xE6, 0xF2, 0x6B, 0xA0, 0x42, 0xEE, 0x61, 
	0x0A, 0x83, 0xA4, 0xC1, 0xAB, 0x31, 0x1D, 0xE4, 0xD1, 0x69, 
	0x0A, 0x7B, 0xBC, 0xDC, 0x54, 0xA7, 0x2A, 0x7A, 0x66, 0xEB, 
	0xB9, 0x11, 0x45, 0x80, 0x86, 0x04, 0xCB, 0x0B, 0x21, 0xDD, 
	0x13, 0x1F, 0xFA, 0x9D, 0x1B, 0xDD, 0xF1, 0x79, 0xD8, 0xF8, 
	0x20, 0x8C, 0x18, 0xA6, 0x88, 0x28, 0xB4, 0xD4, 0x3F, 0x13, 
	0xCA, 0x9D, 0x4C, 0xF2, 0xB8, 0xA1, 0x6B, 0xE9, 0x73, 0x22, 
	0x3C, 0x57, 0xF5, 0xD1, 0x6E, 0x79, 0xB1, 0x8A, 0x5D, 0x86, 
	0xBF, 0x01, 0x07, 0x65, 0x29, 0x34, 0x0D, 0x9C, 0x77, 0xDA, 
	0x34, 0x78, 0x94, 0xD9, 0x63, 0x00, 0x96, 0x0D, 0xBA, 0x23, 
	0x05, 0x6E, 0x3E, 0x62, 0x43, 0x60, 0x5F, 0xF1, 0xEF, 0xE7, 
	0x18, 0xAF, 0x87, 0x25, 0xF4, 0x15, 0xC8, 0x63, 0xA5, 0xCA, 
	0x44, 0x0A, 0x15, 0xCF, 0xB0, 0xDF, 0x09, 0xC1, 0x5F, 0x2C, 
	0xE5, 0x42, 0xA0, 0xC0, 0x82, 0xB5, 0xB2, 0xA2, 0xB4, 0x63, 
	0xCD, 0x5F, 0xD4, 0x88, 0x97, 0x14, 0x28, 0x83, 0xFE, 0x54, 
	0xE1, 0x06, 0x87, 0x31, 0x6C, 0xA7, 0x23, 0x1A, 0x39, 0x94, 
	0xF8, 0x1F, 0xD3, 0x15, 0x18, 0xDB
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
