#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0x80, 0xD2, 0x4E, 0x42, 0xCE, 0x01, 0xB2, 0x76, 0x41, 0xAD, 
	0x11, 0x3E, 0x15, 0x56, 0x67, 0x26, 0x57, 0x82, 0xEB, 0xAB, 
	0xFA, 0xA5, 0x83, 0xF6, 0xE1, 0x3A, 0xC8, 0x9D, 0x77, 0xE1, 
	0x73, 0x0A, 0x77, 0x2E, 0x60, 0x14, 0x29, 0xF4, 0x93, 0x38, 
	0xD2, 0x53, 0xAE, 0x65, 0x5A, 0x38, 0xE6, 0x4F, 0x1E, 0xA2, 
	0x79, 0xF6, 0x83, 0xDF, 0x80, 0x75, 0x33, 0x08, 0x58, 0x59, 
	0xCB, 0x7E, 0x55, 0x23, 0x34, 0x22, 0xFF, 0x9C, 0x60, 0x51, 
	0x97, 0xB7, 0x9A, 0x1F, 0xAE, 0xB0, 0x23, 0x36, 0xE9, 0xDD, 
	0xF2, 0xBE, 0x33, 0xEE, 0xE2, 0xD7, 0x83, 0x5B, 0x70, 0x92, 
	0xDE, 0x6D, 0xA1, 0x60, 0xC8, 0x21, 0x9E, 0x92, 0xCB, 0x42, 
	0xAF, 0x73, 0x7B, 0x62, 0xB5, 0x2E, 0x1E, 0xD3, 0xB7, 0xE8, 
	0x5E, 0x0B, 0x92, 0xAE, 0xFB, 0xAA, 0xC1, 0x49, 0x47, 0x5A, 
	0x33, 0x28, 0x64, 0x0D, 0xA3, 0x05, 0x33, 0x94, 0x05, 0x4B, 
	0xC0, 0xBC, 0xCB, 0x3C, 0xCE, 0xE6, 0x77, 0xF3, 0xD7, 0xFF, 
	0xA5, 0x6E, 0x18, 0xC0, 0xC1, 0x58, 0x80, 0x8C, 0xFB, 0x64, 
	0xFB, 0x53, 0xE1, 0x86, 0x44, 0x7B, 0x44, 0x14, 0x1F, 0xEE, 
	0xF0, 0xA1, 0x81, 0x84, 0xC5, 0x74, 0x55, 0x65, 0x12, 0xED, 
	0x17, 0x4F, 0x3D, 0x37, 0x07, 0xF5, 0xE0, 0x3E, 0xD7, 0x95, 
	0xF9, 0x7D, 0xBD, 0x7A, 0xDB, 0x22, 0xC5, 0xFD, 0x37, 0xB7, 
	0x0B, 0x24, 0x74, 0xC5, 0x9F, 0x7C, 0x05, 0x27, 0x0B, 0x51, 
	0x1F, 0x4A, 0xE2, 0x5C, 0xC0, 0xB0, 0x82, 0x40, 0x33, 0xC0, 
	0x98, 0x1B, 0xFC, 0x5C, 0x68, 0x90, 0x77, 0x80, 0x53, 0x98, 
	0x1C, 0x1B, 0x53, 0xAB, 0x66, 0x45, 0x36, 0xE8, 0x0C, 0xF8, 
	0x6E, 0x75, 0xE8, 0x43, 0x36, 0xDD, 0x2B, 0x78, 0x3E, 0xF0, 
	0x2F, 0xD0, 0xCF, 0xD6, 0xF4, 0xB0, 0x07, 0xDA, 0x44, 0xAF, 
	0x2B, 0x46, 0x63, 0x6E, 0xD8, 0x0B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
