/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "url.h"
#include "util.h"

sURL *URLCreate(const char *URL) {
	sURL *Break = (sURL *)calloc(1, sizeof(sURL));
	static char buf[200];
	Break->Full = strdup(URL);
	sscanf(URL, "%199[a-z]", buf);
	Break->Protocol = strdup(buf);
	URL += strlen(buf);
	if(strncmp(URL, "://", 3)) {
		free(Break->Full);
		free(Break->Protocol);
		return NULL;
	}
	URL += 3;
	sscanf(URL, "%199[a-zA-Z0-9.-]", buf);
	Break->Host = strdup(buf);
	URL += (strlen(buf));
	if(URL[0] == ':') {
		sscanf(URL, ":%5[0-9]", buf);
		Break->Port = strdup(buf);
		URL += (strlen(buf) + 1);
	} else {
		if (!strcmp(Break->Protocol, "http")) {
			Break->Port = strdup("80");
		} else {
			Break->Port = strdup("0");
		}
	}
	if (strlen(URL) < 1) {		// Just a hostname, no trailing slash, but tack it on anyway
		Break->FullPath = strdup("/");
	} else {
		Break->FullPath = strdup(URL);
	}
	if (strlen(Break->FullPath) > 1) {
		// Search for "?"
		int qloc = 1;
		for (int i = 0; i < (int)strlen(Break->FullPath); i++) {
			if(Break->FullPath[i] == '?') {
				break;
			}
			qloc = i + 1;
		}
		for (int i = qloc - 1; i >= 0; i--) {
			if(Break->FullPath[i] == '/') {
				Break->Path = strndup(Break->FullPath, i + 1);
				break;
			}
		}
		URL += (strlen(Break->Path));
		Break->File = strdup(URL);
		Break->Extension = NULL; 		// If this doesn't get set... no extension
		for (int i = strlen(Break->File); i > 0; i--) {
			if(Break->File[i] == '.') {
				sscanf(((Break->File) + i + 1), "%199[a-zA-Z0-9]", buf);
				Break->Extension = strdup(buf);
				break;
			}
		}
		if(!(Break->Extension)) {		// No extension, so put a blank string here
			Break->Extension = strdup("");
		}
	} else {
		Break->Path = strdup(Break->FullPath);
		Break->File = strdup("");
		Break->Extension = strdup("");
	}
	ReplaceSpace(&(Break->FullPath));
	ReplaceSpace(&(Break->Full));
	ReplaceSpace(&(Break->Path));
	ReplaceSpace(&(Break->File));
	ReplaceSpace(&(Break->Extension));
	return Break;
}

char *MakeNewURL(const char *New, sURL *Old) {
	static char buf[400];
	if (New[0] == '/') {
		if (atoi(Old->Port) != 80) {
			snprintf(buf, 400, "%s://%s:%s%s", Old->Protocol, Old->Host, Old->Port, New);
		} else {
			snprintf(buf, 400, "%s://%s%s", Old->Protocol, Old->Host, New);
		}
	} else if (New[0] == '?') {
		if (atoi(Old->Port) != 80) {
			snprintf(buf, 400, "%s://%s:%s%s%s", Old->Protocol, Old->Host, Old->Port, Old->Path, Old->File);
		} else {
			snprintf(buf, 400, "%s://%s%s%s", Old->Protocol, Old->Host, Old->Path, Old->File);
		}
		if (strrchr(buf, '?')) {
			*(strrchr(buf, '?')) = 0;	// Chop the string so we can tack on the new value
		}
		strncat(buf, New, 400 - strlen(New) - strlen(buf));
	} else if (!strncmp(New, "./", 2)) {
		if (atoi(Old->Port) != 80) {
			snprintf(buf, 400, "%s://%s:%s%s%s", Old->Protocol, Old->Host, Old->Port, Old->Path, (New + 2));
		} else {
			snprintf(buf, 400, "%s://%s%s%s", Old->Protocol, Old->Host, Old->Path, (New + 2));
		}
	} else if (!strncmp(New, "../", 3)) {
		bool found = false;
		sprintf(buf, "%s://%s", Old->Protocol, Old->Host);
		if (atoi(Old->Port) != 80) {
			strcat(buf, ":");
			strcat(buf, Old->Port);
		}
		if (strlen(Old->Path) > 1) { 	// We actually have a path (Pockybot fix)
			for(int i = strlen(Old->Path); i >= 0; i--) {	// Chop off one directory
				if ((Old->Path)[i] == '/') {
					if (found) {
						strncat(buf, Old->Path, i + 1);
						break;
					} else {
						found = true;
					}
				}
			}
		} else {
			strcat(buf, "/");
		}
		strcat(buf, (New + 3));
	} else {
		if (atoi(Old->Port) != 80) {
			snprintf(buf, 400, "%s://%s:%s%s%s", Old->Protocol, Old->Host, Old->Port, Old->Path, New);
		} else {
			snprintf(buf, 400, "%s://%s%s%s", Old->Protocol, Old->Host, Old->Path, New);
		}
	}
	return buf;
}

char *URLUnbreak(sURL *Break) {
	static char buf[400];
	if (atoi(Break->Port) != 80) {
		snprintf(buf, 400, "%s://%s:%s%s", Break->Protocol, Break->Host, Break->Port, Break->FullPath);
	} else {
		snprintf(buf, 400, "%s://%s%s", Break->Protocol, Break->Host, Break->FullPath);
	}
	return buf;
}

void URLDelete(sURL *URL) {
	if (URL) {
		free(URL->Full);
		free(URL->Protocol);
		free(URL->Host);
		free(URL->Port);
		free(URL->Path);
		free(URL->FullPath);
		free(URL->File);
		free(URL->Extension);
		free(URL);
	}
}
