/***** This code was generated by Yaggo. Do not edit ******/

/* Quorum
 * Copyright (C) 2012  Genome group at University of Maryland.
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifndef __ARGS_T_HPP__
#define __ARGS_T_HPP__

#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>
#include <stdexcept>
#include <string>
#include <limits>
#include <vector>
#include <iostream>
#include <sstream>
#include <memory>

class args_t {
 // Boiler plate stuff. Conversion from string to other formats
  static bool adjust_double_si_suffix(double &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'a': res *= 1e-18; break;
    case 'f': res *= 1e-15; break;
    case 'p': res *= 1e-12; break;
    case 'n': res *= 1e-9;  break;
    case 'u': res *= 1e-6;  break;
    case 'm': res *= 1e-3;  break;
    case 'k': res *= 1e3;   break;
    case 'M': res *= 1e6;   break;
    case 'G': res *= 1e9;   break;
    case 'T': res *= 1e12;  break;
    case 'P': res *= 1e15;  break;
    case 'E': res *= 1e18;  break;
    default: return false;
    }
    return true;
  }

  static double conv_double(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    double res = strtod(str, &endptr);
    if(errno) {
      err.assign(strerror(errno));
      return (double)0.0;
    }
    bool invalid =
      si_suffix ? !adjust_double_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (double)0.0;
    }
    return res;
  }

  static int conv_enum(const char* str, ::std::string& err, const char* const strs[]) {
    int res = 0;
    for(const char* const* cstr = strs; *cstr; ++cstr, ++res)
      if(!strcmp(*cstr, str))
        return res;
    err += "Invalid constant '";
    err += str;
    err += "'. Expected one of { ";
    for(const char* const* cstr = strs; *cstr; ++cstr) {
      if(cstr != strs)
        err += ", ";
      err += *cstr;
    }
    err += " }";
    return -1;
  }

  template<typename T>
  static bool adjust_int_si_suffix(T &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'k': res *= (T)1000; break;
    case 'M': res *= (T)1000000; break;
    case 'G': res *= (T)1000000000; break;
    case 'T': res *= (T)1000000000000; break;
    case 'P': res *= (T)1000000000000000; break;
    case 'E': res *= (T)1000000000000000000; break;
    default: return false;
    }
    return true;
  }

  template<typename T>
  static T conv_int(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    long long int res = strtoll(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max() ||
       res < ::std::numeric_limits<T>::min()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static T conv_uint(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    while(isspace(*str)) { ++str; }
    if(*str == '-') {
      err.assign("Negative value");
      return (T)0;
    }
    unsigned long long int res = strtoull(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static ::std::string vec_str(const std::vector<T> &vec) {
    ::std::ostringstream os;
    for(typename ::std::vector<T>::const_iterator it = vec.begin();
        it != vec.end(); ++it) {
      if(it != vec.begin())
        os << ",";
      os << *it;
    }
    return os.str();
  }

  class string : public ::std::string {
  public:
    string() : ::std::string() {}
    explicit string(const ::std::string &s) : std::string(s) {}
    explicit string(const char *s) : ::std::string(s) {}
    int as_enum(const char* const strs[]) {
      ::std::string err;
      int res = conv_enum((const char*)this->c_str(), err, strs);
      if(!err.empty())
        throw ::std::runtime_error(err);
      return res;
    }


    uint32_t as_uint32_suffix() const { return as_uint32(true); }
    uint32_t as_uint32(bool si_suffix = false) const {
      ::std::string err;
      uint32_t res = conv_uint<uint32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    uint64_t as_uint64_suffix() const { return as_uint64(true); }
    uint64_t as_uint64(bool si_suffix = false) const {
      ::std::string err;
      uint64_t res = conv_uint<uint64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int32_t as_int32_suffix() const { return as_int32(true); }
    int32_t as_int32(bool si_suffix = false) const {
      ::std::string err;
      int32_t res = conv_int<int32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int64_t as_int64_suffix() const { return as_int64(true); }
    int64_t as_int64(bool si_suffix = false) const {
      ::std::string err;
      int64_t res = conv_int<int64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int as_int_suffix() const { return as_int(true); }
    int as_int(bool si_suffix = false) const {
      ::std::string err;
      int res = conv_int<int>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    long as_long_suffix() const { return as_long(true); }
    long as_long(bool si_suffix = false) const {
      ::std::string err;
      long res = conv_int<long>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to long_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    double as_double_suffix() const { return as_double(true); }
    double as_double(bool si_suffix = false) const {
      ::std::string err;
      double res = conv_double((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to double_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
  };

public:
  uint32_t                       thread_arg;
  bool                           thread_given;
  uint32_t                       min_count_arg;
  bool                           min_count_given;
  uint32_t                       skip_arg;
  bool                           skip_given;
  uint32_t                       good_arg;
  bool                           good_given;
  uint32_t                       anchor_count_arg;
  bool                           anchor_count_given;
  uint32_t                       window_arg;
  bool                           window_given;
  uint32_t                       error_arg;
  bool                           error_given;
  string                         output_arg;
  bool                           output_given;
  const char *                   contaminant_arg;
  bool                           contaminant_given;
  bool                           trim_contaminant_flag;
  int32_t                        homo_trim_arg;
  bool                           homo_trim_given;
  bool                           gzip_flag;
  bool                           no_mmap_flag;
  double                         apriori_error_rate_arg;
  bool                           apriori_error_rate_given;
  double                         poisson_threshold_arg;
  bool                           poisson_threshold_given;
  uint32_t                       cutoff_arg;
  bool                           cutoff_given;
  uint32_t                       qual_cutoff_value_arg;
  bool                           qual_cutoff_value_given;
  string                         qual_cutoff_char_arg;
  bool                           qual_cutoff_char_given;
  bool                           no_discard_flag;
  bool                           verbose_flag;
  const char *                   db_arg;
  ::std::vector<const char *>    sequence_arg;
  typedef ::std::vector<const char *>::iterator sequence_arg_it;
  typedef ::std::vector<const char *>::const_iterator sequence_arg_const_it;

  enum {
    START_OPT = 1000,
    CONTAMINANT_OPT,
    TRIM_CONTAMINANT_OPT,
    HOMO_TRIM_OPT,
    GZIP_OPT,
    APRIORI_ERROR_RATE_OPT,
    POISSON_THRESHOLD_OPT
  };

  args_t() :
    thread_arg((uint32_t)1), thread_given(false),
    min_count_arg((uint32_t)1), min_count_given(false),
    skip_arg((uint32_t)1), skip_given(false),
    good_arg((uint32_t)2), good_given(false),
    anchor_count_arg((uint32_t)3), anchor_count_given(false),
    window_arg((uint32_t)10), window_given(false),
    error_arg((uint32_t)3), error_given(false),
    output_arg("error_corrected"), output_given(false),
    contaminant_arg(""), contaminant_given(false),
    trim_contaminant_flag(false),
    homo_trim_arg(0), homo_trim_given(false),
    gzip_flag(false),
    no_mmap_flag(false),
    apriori_error_rate_arg((double)0.01), apriori_error_rate_given(false),
    poisson_threshold_arg((double)1.0e-06), poisson_threshold_given(false),
    cutoff_arg(0), cutoff_given(false),
    qual_cutoff_value_arg(0), qual_cutoff_value_given(false),
    qual_cutoff_char_arg(""), qual_cutoff_char_given(false),
    no_discard_flag(false),
    verbose_flag(false),
    db_arg(""),
    sequence_arg()
  { }

  args_t(int argc, char* argv[]) :
    thread_arg((uint32_t)1), thread_given(false),
    min_count_arg((uint32_t)1), min_count_given(false),
    skip_arg((uint32_t)1), skip_given(false),
    good_arg((uint32_t)2), good_given(false),
    anchor_count_arg((uint32_t)3), anchor_count_given(false),
    window_arg((uint32_t)10), window_given(false),
    error_arg((uint32_t)3), error_given(false),
    output_arg("error_corrected"), output_given(false),
    contaminant_arg(""), contaminant_given(false),
    trim_contaminant_flag(false),
    homo_trim_arg(0), homo_trim_given(false),
    gzip_flag(false),
    no_mmap_flag(false),
    apriori_error_rate_arg((double)0.01), apriori_error_rate_given(false),
    poisson_threshold_arg((double)1.0e-06), poisson_threshold_given(false),
    cutoff_arg(0), cutoff_given(false),
    qual_cutoff_value_arg(0), qual_cutoff_value_given(false),
    qual_cutoff_char_arg(""), qual_cutoff_char_given(false),
    no_discard_flag(false),
    verbose_flag(false),
    db_arg(""),
    sequence_arg()
  { parse(argc, argv); }

  void parse(int argc, char* argv[]) {
    static struct option long_options[] = {
      {"thread", 1, 0, 't'},
      {"min-count", 1, 0, 'm'},
      {"skip", 1, 0, 's'},
      {"good", 1, 0, 'g'},
      {"anchor-count", 1, 0, 'a'},
      {"window", 1, 0, 'w'},
      {"error", 1, 0, 'e'},
      {"output", 1, 0, 'o'},
      {"contaminant", 1, 0, CONTAMINANT_OPT},
      {"trim-contaminant", 0, 0, TRIM_CONTAMINANT_OPT},
      {"homo-trim", 1, 0, HOMO_TRIM_OPT},
      {"gzip", 0, 0, GZIP_OPT},
      {"no-mmap", 0, 0, 'M'},
      {"apriori-error-rate", 1, 0, APRIORI_ERROR_RATE_OPT},
      {"poisson-threshold", 1, 0, POISSON_THRESHOLD_OPT},
      {"cutoff", 1, 0, 'p'},
      {"qual-cutoff-value", 1, 0, 'q'},
      {"qual-cutoff-char", 1, 0, 'Q'},
      {"no-discard", 0, 0, 'd'},
      {"verbose", 0, 0, 'v'},
      {"help", 0, 0, 'h'},
      {"usage", 0, 0, 'U'},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };
    static const char *short_options = "hVUt:m:s:g:a:w:e:o:Mp:q:Q:dv";

    ::std::string err;
#define CHECK_ERR(type,val,which) if(!err.empty()) { ::std::cerr << "Invalid " #type " '" << val << "' for [" which "]: " << err << "\n"; exit(1); }
    while(true) {
      int index = -1;
      int c = getopt_long(argc, argv, short_options, long_options, &index);
      if(c == -1) break;
      switch(c) {
      case ':':
        ::std::cerr << "Missing required argument for "
                  << (index == -1 ? ::std::string(1, (char)optopt) : std::string(long_options[index].name))
                  << ::std::endl;
        exit(1);
      case 'h':
        ::std::cout << usage() << "\n\n" << help() << std::endl;
        exit(0);
      case 'U':
        ::std::cout << usage() << "\nUse --help for more information." << std::endl;
        exit(0);
      case 'V':
        print_version();
        exit(0);
      case '?':
        ::std::cerr << "Use --usage or --help for some help\n";
        exit(1);
      case 't':
        thread_given = true;
        thread_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-t, --thread=uint32")
        break;
      case 'm':
        min_count_given = true;
        min_count_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-m, --min-count=uint32")
        break;
      case 's':
        skip_given = true;
        skip_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-s, --skip=uint32")
        break;
      case 'g':
        good_given = true;
        good_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-g, --good=uint32")
        break;
      case 'a':
        anchor_count_given = true;
        anchor_count_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-a, --anchor-count=uint32")
        break;
      case 'w':
        window_given = true;
        window_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-w, --window=uint32")
        break;
      case 'e':
        error_given = true;
        error_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-e, --error=uint32")
        break;
      case 'o':
        output_given = true;
        output_arg.assign(optarg);
        break;
      case CONTAMINANT_OPT:
        contaminant_given = true;
        contaminant_arg = optarg;
        break;
      case TRIM_CONTAMINANT_OPT:
        trim_contaminant_flag = true;
        break;
      case HOMO_TRIM_OPT:
        homo_trim_given = true;
        homo_trim_arg = conv_int<int32_t>((const char*)optarg, err, false);
        CHECK_ERR(int32_t, optarg, "    --homo-trim=int32")
        break;
      case GZIP_OPT:
        gzip_flag = true;
        break;
      case 'M':
        no_mmap_flag = true;
        break;
      case APRIORI_ERROR_RATE_OPT:
        apriori_error_rate_given = true;
        apriori_error_rate_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "    --apriori-error-rate=double")
        break;
      case POISSON_THRESHOLD_OPT:
        poisson_threshold_given = true;
        poisson_threshold_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "    --poisson-threshold=double")
        break;
      case 'p':
        cutoff_given = true;
        cutoff_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-p, --cutoff=uint32")
        break;
      case 'q':
        qual_cutoff_value_given = true;
        qual_cutoff_value_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-q, --qual-cutoff-value=uint32")
        break;
      case 'Q':
        qual_cutoff_char_given = true;
        qual_cutoff_char_arg.assign(optarg);
        break;
      case 'd':
        no_discard_flag = true;
        break;
      case 'v':
        verbose_flag = true;
        break;
      }
    }

    // Check mutually exlusive switches
    if(qual_cutoff_char_given && qual_cutoff_value_given)
      error("Switches [-Q, --qual-cutoff-char=string] and [-q, --qual-cutoff-value=uint32] are mutually exclusive");

    // Parse arguments
    if(argc - optind < 2)
      error("Requires at least 2 arguments.");
    db_arg = argv[optind];
    ++optind;
    for( ; optind < argc; ++optind) {
      sequence_arg.push_back(argv[optind]);
    }
  }
  static const char * usage() { return "Usage: error_correct_reads [options] db:path sequence:path+"; }
  class error {
    int code_;
    std::ostringstream msg_;

    // Select the correct version (GNU or XSI) version of
    // strerror_r. strerror_ behaves like the GNU version of strerror_r,
    // regardless of which version is provided by the system.
    static const char* strerror__(char* buf, int res) {
      return res != -1 ? buf : "Invalid error";
    }
    static const char* strerror__(char* buf, char* res) {
      return res;
    }
    static const char* strerror_(int err, char* buf, size_t buflen) {
      return strerror__(buf, strerror_r(err, buf, buflen));
    }
    struct no_t { };

  public:
    static no_t no;
    error(int code = EXIT_FAILURE) : code_(code) { }
    explicit error(const char* msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error(const std::string& msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error& operator<<(no_t) {
      char buf[1024];
      msg_ << ": " << strerror_(errno, buf, sizeof(buf));
      return *this;
    }
    template<typename T>
    error& operator<<(const T& x) { msg_ << x; return (*this); }
    ~error() {
      ::std::cerr << "Error: " << msg_.str() << "\n"
                  << usage() << "\n"
                  << "Use --help for more information"
                  << ::std::endl;
      exit(code_);
    }
  };
  static const char * help() { return
    "Error correct reads from a fastq file based on the k-mer frequencies.\n\n"
    "Options (default value in (), *required):\n"
    " -t, --thread=uint32                      Number of threads (1)\n"
    " -m, --min-count=uint32                   Minimum count for a k-mer to be considered \"good\" (1)\n"
    " -s, --skip=uint32                        Number of bases to skip for start k-mer (1)\n"
    " -g, --good=uint32                        Number of good k-mer in a row for anchor (2)\n"
    " -a, --anchor-count=uint32                Minimum count for an anchor k-mer (3)\n"
    " -w, --window=uint32                      Size of window (10)\n"
    " -e, --error=uint32                       Maximum number of error in a window (3)\n"
    " -o, --output=prefix                      Output file prefix (error_corrected)\n"
    "     --contaminant=path                   Jellyfish database of contaminant k-mers\n"
    "     --trim-contaminant                   Trim reads containing contaminated k-mers instead of discarding (false)\n"
    "     --homo-trim=int32                    Trim homo-polymer run at the 3' end\n"
    "     --gzip                               Gzip output file (false)\n"
    " -M, --no-mmap                            Do not memory map the input mer database (false)\n"
    "     --apriori-error-rate=double          Probability of a base being an error (0.01)\n"
    "     --poisson-threshold=double           Error probability threshold in Poisson test (1.0e-06)\n"
    " -p, --cutoff=uint32                      Poisson cutoff when there are multiple choices\n"
    " -q, --qual-cutoff-value=uint32           Any base above with quality equal or greater is untouched when there are multiple choices\n"
    " -Q, --qual-cutoff-char=string            Any base above with quality equal or greater is untouched when there are multiple choices\n"
    " -d, --no-discard                         Do not discard reads, output a single N (false)\n"
    " -v, --verbose                            Be verbose (false)\n"
    " -U, --usage                              Usage\n"
    " -h, --help                               This message\n"
    " -V, --version                            Version";
  }
  static const char* hidden() { return ""; }
  void print_version(::std::ostream &os = std::cout) const {
#ifndef PACKAGE_VERSION
#define PACKAGE_VERSION "0.0.0"
#endif
    os << PACKAGE_VERSION << "\n";
  }
  void dump(::std::ostream &os = std::cout) {
    os << "thread_given:" << thread_given << " thread_arg:" << thread_arg << "\n";
    os << "min_count_given:" << min_count_given << " min_count_arg:" << min_count_arg << "\n";
    os << "skip_given:" << skip_given << " skip_arg:" << skip_arg << "\n";
    os << "good_given:" << good_given << " good_arg:" << good_arg << "\n";
    os << "anchor_count_given:" << anchor_count_given << " anchor_count_arg:" << anchor_count_arg << "\n";
    os << "window_given:" << window_given << " window_arg:" << window_arg << "\n";
    os << "error_given:" << error_given << " error_arg:" << error_arg << "\n";
    os << "output_given:" << output_given << " output_arg:" << output_arg << "\n";
    os << "contaminant_given:" << contaminant_given << " contaminant_arg:" << contaminant_arg << "\n";
    os << "trim_contaminant_flag:" << trim_contaminant_flag << "\n";
    os << "homo_trim_given:" << homo_trim_given << " homo_trim_arg:" << homo_trim_arg << "\n";
    os << "gzip_flag:" << gzip_flag << "\n";
    os << "no_mmap_flag:" << no_mmap_flag << "\n";
    os << "apriori_error_rate_given:" << apriori_error_rate_given << " apriori_error_rate_arg:" << apriori_error_rate_arg << "\n";
    os << "poisson_threshold_given:" << poisson_threshold_given << " poisson_threshold_arg:" << poisson_threshold_arg << "\n";
    os << "cutoff_given:" << cutoff_given << " cutoff_arg:" << cutoff_arg << "\n";
    os << "qual_cutoff_value_given:" << qual_cutoff_value_given << " qual_cutoff_value_arg:" << qual_cutoff_value_arg << "\n";
    os << "qual_cutoff_char_given:" << qual_cutoff_char_given << " qual_cutoff_char_arg:" << qual_cutoff_char_arg << "\n";
    os << "no_discard_flag:" << no_discard_flag << "\n";
    os << "verbose_flag:" << verbose_flag << "\n";
    os << "db_arg:" << db_arg << "\n";
    os << "sequence_arg:" << vec_str(sequence_arg) << "\n";
  }
};
#endif // __ARGS_T_HPP__"
