""" dialogs.py

Module for displaying dialogs related to errors, warnings, notifications,
etc...
"""
__copyright__ = "Copyright (c) 2002-2005 Free Software Foundation, Inc."
__license__ = """
Straw is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

Straw is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """

import pygtk
pygtk.require('2.0')
import gobject
import gtk
import gnome
import error
import FeedCategoryList
import FeedList
import OPMLExport
import OPMLImport
import utils
import constants
import gnome.ui

def _setup_filechooser_dialog(title, action, extra_widget_title):
    """
    Setup the file chooser dialog. This includes an extra widget (a combobox)
    to include the categories to import or export
    """
    dialog = gtk.FileChooserDialog(title, action=action,
                                   buttons=(gtk.STOCK_CANCEL,
                                            gtk.RESPONSE_CANCEL,
                                            gtk.STOCK_OK, gtk.RESPONSE_OK))
    category_list = FeedCategoryList.get_instance()
    model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_PYOBJECT)
    combobox = gtk.ComboBox(model)
    celltitle = gtk.CellRendererText()
    combobox.pack_start(celltitle,False)
    combobox.add_attribute(celltitle, 'text', 0)

    # add 'All' Category
    it = model.append()
    model.set(it, 0, category_list.all_category.title,
              1, category_list.all_category)

    # add user categories
    for category in category_list.user_categories:
        it = model.append()
        model.set(it, 0, category.title, 1, category)

    # ..
    combobox.set_active(0)
    label = gtk.Label(extra_widget_title)
    label.set_alignment(1.0,0.5)
    hbox = gtk.HBox(spacing=6)
    hbox.pack_start(label,True,True,0)
    hbox.pack_end(combobox,False,False,0)
    hbox.show_all()

    dialog.set_extra_widget(hbox)
    return (dialog, combobox)


def export_subscriptions(parent):
    (dialog,combobox) = _setup_filechooser_dialog(_("Export Subscriptions"),
                                                  gtk.FILE_CHOOSER_ACTION_SAVE,
                                                  _("Select category to export:"))
    def selection_changed(widget, dialog):
        model = widget.get_model()
        category = model[widget.get_active()][1]
        dialog.set_current_name("Straw-%s.xml" % category.title)

    combobox.connect('changed',
                     selection_changed,
                     dialog)
    selection_changed(combobox, dialog)
    dialog.set_transient_for(parent)
    response = dialog.run()
    if response == gtk.RESPONSE_OK:
        filename = dialog.get_filename()
        model = combobox.get_model()
        cat = model[combobox.get_active()][1]
        OPMLExport.export(cat.title, cat.feeds, filename)
    dialog.destroy()

def import_subscriptions(parent):
    (dialog,combobox) = _setup_filechooser_dialog(_("Import Subscriptions"),
                                                  gtk.FILE_CHOOSER_ACTION_OPEN,
                                                  _("Add new subscriptions in:"))
    ffilter = gtk.FileFilter()
    ffilter.set_name(_("OPML Files Only"))
    ffilter.add_pattern("*.xml")
    ffilter.add_pattern("*.opml")
    dialog.add_filter(ffilter)
    dialog.set_transient_for(parent)
    response = dialog.run()
    if response == gtk.RESPONSE_OK:
        filename = dialog.get_filename()
        model = combobox.get_model()
        cat = model[combobox.get_active()][1]
        dialog.hide()
        OPMLImport.import_opml(filename, cat)
    dialog.destroy()

def report_error(primary, secondary, parent=None):
    dialog = gtk.MessageDialog(parent,
                               type=gtk.MESSAGE_ERROR,
                               buttons=gtk.BUTTONS_OK,
                               message_format=primary)
    dialog.format_secondary_text(secondary)
    response = dialog.run()
    dialog.destroy()
    return response

def report_offline_status(parent=None):
    dialog = gtk.MessageDialog(parent,
                               type=gtk.MESSAGE_WARNING,
                               buttons=gtk.BUTTONS_OK_CANCEL,
                               message_format="You Are Offline!")
    dialog.format_secondary_markup(_("You are currently reading offline. Would you like to go online now?"))
    response = dialog.run()
    dialog.destroy()
    return response

def confirm_delete(primary, secondary,parent=None):
    dialog = gtk.MessageDialog(parent,
                               type=gtk.MESSAGE_QUESTION,
                               buttons=gtk.BUTTONS_OK_CANCEL,
                               message_format=primary)
    dialog.format_secondary_text(secondary)
    response = dialog.run()
    dialog.hide()
    return response

def credits():
    import os, os.path
    import gettext
    iconfile = os.path.join(utils.find_image_dir(),"straw.png")
    logo = gtk.gdk.pixbuf_new_from_file(iconfile)
    description = _("A feed aggregator for the GNOME Desktop")
    straw_copyright = u"""
    Copyright \xa9 2002-2004 Juri Pakaste
    Copyright \xa9 2005-2006 Straw Contributors"""
    people = [
        u"Iain McCoy <iain@mccoy.id.au>",
        u"Jan Alonzo <jmalonzo@unpluggable.com>",
        u"Juri Pakaste <juri@iki.fi>",
        u"Lucas Nussbaum <lucas@lucas-nussbaum.net>",
        u"Mark Pilgrim (feedparser and feedfinder)",
        u"Olivier Crete <tester@tester.ca>",
        u"Ryan P. Skadberg <skadz@stigmata.org>",
        u"Scott Douglas-Watson <sdouglaswatson@yahoo.co.uk>",
        u"Terje R\xf8sten (distutils)"]

    artists = [
        u"Jakub 'jimmac' Steiner"
        ]

    translators = [
        u"Juri Pakaste <juri@iki.fi>",
        u"Martin Steldinger <tribble@hanfplantage.de>",
        u"David Rousseau <boiteaflood@wanadoo.fr>",
        u"Sergei Vavinov <svv@cmc.msu.ru>",
        u"Terje R\xf8sten <terjeros@phys.ntnu.no>",
        u"Francisco J. Fernandez <franciscojavier.fernandez.serrador@hispalinux.es>",
        u"Elros Cyriatan (Dutch Translation)",
        u"GNOME i18n team <http://developer.gnome.org/projects/gtp/>"
        ]

    translator_credits = 'translator_credits'
    if constants.pygtk_version() >= (2,6,0):
        about = gtk.AboutDialog()
        about.set_name(constants.APPNAME)
        about.set_version(constants.VERSION)
        about.set_copyright(straw_copyright)
        about.set_comments(description)
        about.set_authors(people)
        artists.append(u'Juri Pakaste')
        about.set_artists(artists)
        about.set_logo(logo)
        about.set_translator_credits(translator_credits)
        about.set_license(__license__)
        gtk.about_dialog_set_url_hook(lambda about, url: utils.url_show(url))
        about.set_website(constants.STRAW_URL)
        about.set_website_label(constants.STRAW_URL)
    else:
        about = gnome.ui.About(
            constants.APPNAME, constants.VERSION, straw_copyright, description,
            people+artists, [], "\n".join(translators),logo)
        about.set_icon(logo)
    return about
