use layout;
use core:geometry;
// TODO: export layout; so that it is automatically included where we're used!

/**
 * Wrappers for using the layout library together with the Ui library.
 */


/**
 * Wrapper around windows in the UI class.
 */
class UiComponent extends Component {
	// The window we're wrapping.
	Window window;

	// Minimum width of the component.
	Float minWidth;

	// Minimum height of the component.
	Float minHeight;

	// Create.
	init(Window window) {
		init() { window = window; }
	}

	// Get position.
	Rect pos() {
		window.pos;
	}

	// Set position.
	assign pos(Rect p) {
		window.pos = p;
	}

	// Minimum size.
	Size minSize() {
		Size r = window.minSize();
		r.w = max(r.w, minWidth);
		r.h = max(r.h, minHeight);
		r;
	}
}

// Create components.
UiComponent component(Window window) {
	UiComponent(window);
}

/**
 * Wrap the root layout.
 */
class UiRoot extends Border {
	// Current size, as reported by the owner.
	private Rect current;

	// Create, optionally adding a component at the same time.
	init() {
		init();
	}

	// Create, optionally adding a component at the same time.
	init(Component c) {
		init();
		add(c);
	}

	// Set the size.
	void resize(Size s) {
		current = Rect(s);
		layout();
	}

	// Get the size.
	Rect pos() {
		current;
	}
}
