/*
 * Copyright (C) 2015 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michi Henning <michi.henning@canonical.com>
 */

#include "gtest_printer.h"

#include <QString>
#include <ostream>

using namespace std;

ostream& operator<<(ostream& stream, const QString& s)
{
    return stream << s.toUtf8().constData();
}

ostream& operator<<(ostream& stream, const char* s)
{
    return std::operator<<(stream, s);
}

void PrintTo(const QString& s, ostream* stream)
{
    *stream << s;
}
