/***************************************************************************
 *   Copyright (C) 2005 by Bjoern Erik Nilsen & Fredrik Berg Kjoelstad     *
 *   bjoern.nilsen@bjoernen.com     & fredrikbk@hotmail.com                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEDIALOG_H
#define FILEDIALOG_H

#include <qfiledialog.h>

/**
 * Extended QFileDialog with an additional tool button
 * for quickly getting into the users home directory.
 *
 * @author Bjoern Erik Nilsen & Fredrik Berg Kjoelstad
 */
class FileDialog : public QFileDialog
{
	Q_OBJECT
public:
	/**
	 * Sets up the file dialog. See the Qt Reference Documentation for
	 * information about the parameters.
	 */
	FileDialog(const QString & dirName, const QString & filter = QString::null, 
		 QWidget * parent = 0, const char * name = 0, bool modal = FALSE);

	/**
	 * Sets up the file dialog. See the Qt Reference Documentation for
	 * information about the parameters.
	 */
	FileDialog(QWidget * parent = 0, const char * name = 0, bool modal = FALSE );
	
private slots:
	
	/**
	 * Sets the directory to be the users home directory.
	 */
	void goToHomeDir();

};

#endif
