/*
 * Stellarium: Meteor Showers Plug-in
 * Copyright (C) 2015 Marcos Cardinot
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335, USA.
 */

// This file contains translations for all meteor shower names and their parent objects.
// It is not meant to be compiled but just parsed by gettext.
class MSTranslations
{
	void MSTranslations(){;}

	static translationList()
	{
		// Generate Gettext strings for traduction
		Q_ASSERT(0);

		// Meteor showers
		// TRANSLATORS: Name of meteor shower
		N_("Quadrantids");
		// TRANSLATORS: Name of meteor shower
		N_("Lyrids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Centaurids");
		// TRANSLATORS: Name of meteor shower
		N_("γ-Normids");
		// TRANSLATORS: Name of meteor shower
		N_("η-Aquariids");
		// TRANSLATORS: Name of meteor shower
		N_("June Bootids");
		// TRANSLATORS: Name of meteor shower
		N_("Piscis Austrinids");
		// TRANSLATORS: Name of meteor shower
		N_("Southern δ-Aquariids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Capricornids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Aurigids");
		// TRANSLATORS: Name of meteor shower
		N_("September ε-Perseids");
		// TRANSLATORS: Name of meteor shower
		N_("Draconids");
		// TRANSLATORS: Name of meteor shower
		N_("Leonids");
		// TRANSLATORS: Name of meteor shower
		N_("Phoenicids");
		// TRANSLATORS: Name of meteor shower
		N_("Puppid-Velids");
		// TRANSLATORS: Name of meteor shower
		N_("Ursids");
		// TRANSLATORS: Name of meteor shower
		N_("Perseids");
		// TRANSLATORS: Name of meteor shower
		N_("δ-Leonids");
		// TRANSLATORS: Name of meteor shower
		N_("π-Puppids");
		// TRANSLATORS: Name of meteor shower
		N_("June Lyrids");
		// TRANSLATORS: Name of meteor shower
		N_("κ-Cygnids");
		// TRANSLATORS: Name of meteor shower
		N_("ε-Lyrids");
		// TRANSLATORS: Name of meteor shower
		N_("δ-Aurigids");
		// TRANSLATORS: Name of meteor shower
		N_("ε-Geminids");
		// TRANSLATORS: Name of meteor shower
		N_("Southern Taurids");
		// TRANSLATORS: Name of meteor shower
		N_("Northern Taurids");
		// TRANSLATORS: Name of meteor shower
		N_("Monocerotids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Monocerotids");
		// TRANSLATORS: Name of meteor shower
		N_("σ-Hydrids");
		// TRANSLATORS: Name of meteor shower
		N_("Geminids");
		// TRANSLATORS: Name of meteor shower
		N_("Leonis Minorids");
		// TRANSLATORS: Name of meteor shower
		N_("December Leonis Minorids");
		// TRANSLATORS: Name of meteor shower
		N_("Comae Berenicids");
		// TRANSLATORS: Name of meteor shower
		N_("Orionids");
		// TRANSLATORS: Name of meteor shower
		N_("Andromedids");
		// TRANSLATORS: Name of meteor shower
		N_("η-Lyrids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Scorpiids");
		// TRANSLATORS: Name of meteor shower
		N_("Ophiuchids");
		// TRANSLATORS: Name of meteor shower
		N_("θ-Ophiuchids");
		// TRANSLATORS: Name of meteor shower
		N_("κ-Serpentids");
		// TRANSLATORS: Name of meteor shower
		N_("θ-Centaurids");
		// TRANSLATORS: Name of meteor shower
		N_("ω-Cetids");
		// TRANSLATORS: Name of meteor shower
		N_("Southern ω-Scorpiids");
		// TRANSLATORS: Name of meteor shower
		N_("Northern ω-Scorpiids");
		// TRANSLATORS: Name of meteor shower
		N_("Arietids");
		// TRANSLATORS: Name of meteor shower
		N_("π-Cetids");
		// TRANSLATORS: Name of meteor shower
		N_("δ-Cancrids");
		// TRANSLATORS: Name of meteor shower
		N_("τ-Herculids");
		// TRANSLATORS: Name of meteor shower
		N_("ρ-Geminids");
		// TRANSLATORS: Name of meteor shower
		N_("η-Carinids");
		// TRANSLATORS: Name of meteor shower
		N_("η-Craterids");
		// TRANSLATORS: Name of meteor shower
		N_("π-Virginids");
		// TRANSLATORS: Name of meteor shower
		N_("θ-Virginids");
		// TRANSLATORS: Name of meteor shower
		N_("May Librids");
		// TRANSLATORS: Name of meteor shower
		N_("June Scutids");
		// TRANSLATORS: Name of meteor shower
		N_("α-Pisces Australids");
		// TRANSLATORS: Name of meteor shower
		N_("Southern ι-Aquariids");
		// TRANSLATORS: Name of meteor shower
		N_("Northern ι-Aquariids");
		// TRANSLATORS: Name of meteor shower
		N_("γ-Aquariids");
		// TRANSLATORS: Name of meteor shower
		N_("Autumn Arietids");
		// TRANSLATORS: Name of meteor shower
		N_("χ-Orionids");
		// TRANSLATORS: Name of meteor shower
		N_("Sextantids");
		// TRANSLATORS: Name of meteor shower
		N_("November Orionids");

		// List of parent objects for meteor showers
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 1P/Halley");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 7P/Pons-Winnecke");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 55P/Tempel-Tuttle");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 96P/Machholz");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 109P/Swift-Tuttle");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet Thatcher (1861 I)");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 26P/Grigg-Skjellerup");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 21P/Giacobini-Zinner");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 169P/NEAT");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 289P/Blanpain");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 8P/Tuttle");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 3D/Biela");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet C/1917 F1 (Mellish)");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet C/1964 N1 (Ikeya)");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet Schwassmann-Wachmann 3");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Minor planet 2003 EH1 and Comet C/1490 Y1");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Minor planet (4450) Pan");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Minor planet 2008 ED69");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Comet 2P/Encke");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Minor planet 2004 TG10");
		// TRANSLATORS: Name of parent object for meteor shower
		N_("Minor planet (3200) Phaethon");
	}
};
