

public string ref ="";
public string uref="";
public int is_id=1;
private string ns ="";


/**
 * <p>translate an id to custom uri</p>
 * 
 * 
 * @param id - the id to create a uri for
 * @param no_convert - if set the id wont be transformed
 * 
 */
public void create(string id, int|void no_convert)
{

    ns=get_ns(id);
    if(ns!="")
    {
	  //exp. xsd:string will be unchanged
	  uref=id;
	  ref=uref;
    }
    else if(no_convert)
    {
	    //delete a possible trailing #
	    ref="#"+(unreference(id));
	    uref=unreference(ref);
    }
    else if(!no_convert)
    {
	    ref=reference(unreference(id));
	    uref=unreference(ref);
    }
}

/**
 * <p>Retruns the namespace of the id</p>
 * 
 * 
 * @param id - the id to check
 * @return namespace - the namespace xsd owl etc.
 * 
 */
public string get_ns(string id)
{
    string prefix="";
    int basename_separator_pos = search(id,":");
    if(basename_separator_pos>0)
    {
	string base = id[0..basename_separator_pos];
	string identifier = id[basename_separator_pos+1..];
	switch (base)
	{
	    case "xsd:":
	    prefix="xsd";
	    break;
	    
	    case "owl:":
	    prefix="owl";
	    break;
	    
	    case "rdfs:":
	    prefix="rdfs";
	    break;
	    
	    case "rdf:":
	    prefix="rdf";
	    break;
	    
	    
	}
	
    }
    
    return prefix;
}
/**
 * <p>Checks if the reference has a given namesspace</p>
 * 
 * 
 * @param ns - the namespace to check for
 * @return bool
 */
public int has_ns(string ns) 
{ 
	if(this_program::ns==ns)
		return 1;
	else
		return 0;
}
/**
 * <p>Creates a custom referenced uri</p>
 * Creates an id with a hash value of the id and the current timestamp
 * 
 * @param id - the id to reference 
 * @return 
 */
private string reference(string id) 
{        
	
	 if(has_prefix(id, "Thing"))
	 return "#"+id;
         if(has_prefix(id, "#Thing"))
	 return id;
	 if(has_prefix(id, "xsd:"))
	 return id;
	 if(has_prefix(id, "#visconte_item"))
	 return id;
	 if(has_prefix(id, "visconte_item"))
	 return "#"+id;
	 else
	 {
		 id=String.trim_whites(id);
		 string hash = (string) hash(lower_case(id)+(string) time());
		 //uncomment to use restrictive id
		 // return "#visconte_item"+hash(lower_case(id));
		 return "#visconte_item"+hash;
	 }
	   return id; 
    }
    
/**
 * <p>Unreferencing an id</p>
 * 
 * 
 * @param id - the id to unreference
 * @return 
 */
    public string unreference(string id) 
    { 
	    if(has_prefix(id, "#"))
		    return id[1..];
	    else
		    return id;
    }

