/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: ObjectFactory.pike,v 1.2 2006/08/07 20:51:13 exodusd Exp $
 */

constant cvs_version="$Id: ObjectFactory.pike,v 1.2 2006/08/07 20:51:13 exodusd Exp $";

inherit "/kernel/factory";

//! This factory creates Objects.

import Attributes;

#include <classes.h>
#include <macros.h>
#include <events.h>
#include <access.h>
#include <database.h>
#include <attributes.h>
#include <types.h>

static void init_factory()
{
    ::init_factory();
}

/**
 * The execute function - create a new instance of type "Object"
 *  
 * @param mapping vars - variables like name and description
 *                'name' - the name
 *                'attributes' - default attributes
 *                'transient' - for temporary objects
 * @return the newly created object
 * @author <a href="mailto:astra@upb.de">Thomas Bopp</a>) 
 */
object execute(mapping vars)
{
    object obj;

    string name = vars["name"];
    try_event(EVENT_EXECUTE, CALLER, obj);

    if ( !mappingp(vars->attributes) )
      vars->attributes = ([ ]);
    if ( vars->transient )
      vars->attributes[OBJ_TEMP] = 1;
    obj = ::object_create(name, get_class_name(), 0, 
			  vars["attributes"], vars["attributesAcquired"],
			  vars["attributesLocked"]);

    if ( stringp(vars["description"]) )
	obj->set_attribute(OBJ_DESC, vars["description"]);
    string language = this_user()->query_attribute(USER_LANGUAGE);
    if ( stringp(language) )
      obj->set_attribute(OBJ_LANGUAGE, language);

    run_event(EVENT_EXECUTE, CALLER, obj);
    return obj->this();
}

void change_creator ( object obj, object new_creator ) {
  if ( ! GROUP("admin")->is_member( this_user() ) )
    THROW( "Unauthorized call to factory:set_creator() by " + this_user()->get_identifier() + " !", E_ACCESS );
  if ( !objectp(new_creator) || !(new_creator->get_object_class() & CLASS_USER) )
    steam_error( sprintf( "Invalid new creator for object, cannot change creator !\n* object: %O\n* new creator: %O", obj, new_creator ) );
  if ( !objectp(obj) )
    steam_error( sprintf( "Invalid object, cannot change creator !\n* object: %O\n* new creator: %O", obj, new_creator ) );
  obj->set_creator( new_creator );
}

string get_identifier() { return "Object.factory"; }
string get_class_name() { return "Object"; }
int get_class_id() { return CLASS_OBJECT; }

bool test() 
{
    Attribute attr = Attribute("test", "test", CMD_TYPE_STRING,0,this());
    register_attribute(attr);
    object o = execute( (["name": "test", ]) );
    if ( o->get_acquire_attribute("test") != this() )
	steam_error("Acquire of test object does not match !");
    destruct(attr);
    return true;
    
}

