/*
    IndicatorController.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using Gtk;
using Steadyflow.Core;

namespace Steadyflow {

private const string INDICATOR_MENU = """
<ui>
	<popup name="IndicatorMenu">
		<menuitem action="ShowHide" />
		<menuitem action="Add" />
		<separator />
		<placeholder name="ItemMenus" />
		<separator />
		<menuitem action="Quit" />
	</popup>
</ui>
""";

public class IndicatorController : GLib.Object {
	private ActionEntry[] actions = {
		ActionEntry () { name = "Add", stock_id = Stock.ADD, label = _("_Add download...") },
		ActionEntry () { name = "Quit", stock_id = Stock.QUIT }
	};
	
	private ToggleActionEntry[] toggle_actions = {
		ToggleActionEntry () { name = "ShowHide", label = _("Show download manager") }
	};
	
	private UIManager ui_manager;
	private Menu menu;
	private ToggleAction show_hide_action;
	
	public IndicatorController() {
		ui_manager = new UIManager ();
		Gtk.ActionGroup action_group = new Gtk.ActionGroup ("main");
		action_group.add_actions (actions, null);
		action_group.add_toggle_actions (toggle_actions, null);
		ui_manager.insert_action_group (action_group, 0);
		
		try {
			ui_manager.add_ui_from_string (INDICATOR_MENU, INDICATOR_MENU.length);
		} catch (Error e) {
			Util.fatal_error (e);
		}
		
		menu = (Menu) ui_manager.get_widget ("/ui/IndicatorMenu");
		Services.indicator.set_menu (menu);
		Services.indicator.visible = Services.settings.get_boolean ("show-indicator");

		Services.settings.changed["show-indicator"].connect (() => {
			Services.indicator.visible = Services.settings.get_boolean ("show-indicator");
		});
		
		show_hide_action = (ToggleAction) action_group.get_action ("ShowHide");
		show_hide_action.active = !Services.settings.get_boolean ("start-minimized");
		show_hide_action.toggled.connect (() => { show_hide_toggled (show_hide_action.active); });
		
		action_group.get_action ("Add").activate.connect (() => { add_download_clicked (); });
		action_group.get_action ("Quit").activate.connect (() => { quit_clicked (); });
	}
	
	public void set_main_window_visible (bool visible) {
		show_hide_action.active = visible;
	}
	
	public signal void show_hide_toggled (bool visible);
	public signal void add_download_clicked ();
	public signal void quit_clicked ();
}

}
