package net.sf.statcvs.pages;

import net.sf.statcvs.Messages;

/**
 * @author Richard Cyganiak (richard@cyganiak.de)
 * @version $Id: MarkupHTML.java,v 1.5 2008/06/25 20:46:43 benoitx Exp $
 */
public class MarkupHTML implements MarkupSyntax {
    private final static MarkupSyntax instance = new MarkupHTML();

    public static MarkupSyntax getInstance() {
        return instance;
    }

    private MarkupHTML() {
        // Singleton
    }

    public String getExtension() {
        return "html";
    }

    public String getHeader(final String pageName, final String stylesheetURL, final String charSet) {
        return "<?xml version=\"1.0\"?>\n" + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" "
                + "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n" + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n" + "<head>\n    <title>"
                + Messages.getString("PROJECT_SHORTNAME") + " - " + pageName + "</title>\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; "
                + "charset=" + charSet + "\"/>\n" + "    <meta name=\"Generator\" content=\"" + Messages.getString("PROJECT_SHORTNAME") + " "
                + Messages.getString("PROJECT_VERSION") + "\"/>\n" + "    <link rel=\"stylesheet\" href=\"" + HTML.escape(stylesheetURL)
                + "\" type=\"text/css\"/>\n" + "  </head>\n\n" + "<body>\n";
    }

    public String getEndOfPage() {
        return "</body>\n</html>";
    }

    public String startSection1(final String title) {
        return "\n<h1>" + title + "</h1>\n";
    }

    public String endSection1() {
        return "";
    }

    public String startSection2(final String title) {
        return "\n<div class=\"section\">\n<h2>" + title + "</h2>\n";
    }

    public String startSection2(final String title, final String id) {
        return "\n<div id=\"" + HTML.escape(id) + "\" class=\"section\">\n<h2>" + title + "</h2>\n";
    }

    public String endSection2() {
        return "</div>";
    }

    public String getTableFormat() {
        return "";
    }

    public String toString() {
        return "HTML";
    }
}
