#!/usr/bin/env python
# -*- coding: utf-8 -*-

from distutils.core import setup
import glob, os, commands, sys

data_files = []
if sys.argv[1] == 'install':
    if not os.path.isdir('build'):
        os.makedirs('build')
    os.system('intltool-merge -d po data/startupmanager.desktop.in build/startupmanager.desktop')
    data_files += [('share/applications', ['build/startupmanager.desktop'])]
    os.system('intltool-merge -d po data/startupmanager-kde.desktop.in build/startupmanager-kde.desktop')
    data_files += [('share/applications/kde', ['build/startupmanager-kde.desktop'])]
    data_files += [('share/gnome/help/startupmanager/C', ['data/startupmanager.xml'])]

    data_files += [('share/startupmanager', ['data/gtk_frontend.py', 'data/startupmanager.glade', 'data/startupmanager.svg'])]
    data_files += [('share/icons', ['data/startupmanager.svg'])]
    data_files += [('sbin', ['startupmanager'])]

    for name in os.listdir(os.path.join(os.path.realpath('.'), 'po')):
        if name[-2:] == 'po':
            if not os.path.isdir('build/locale/' + name[:-3]):
                os.makedirs('build/locale/' + name[:-3])
            if not os.path.isdir('build/doc/' + name[:-3]):
                os.makedirs('build/doc/' + name[:-3])
            os.system('msgfmt -o build/locale/' + name[:-3] + '/startupmanager.mo po/' + name[:-3] + '.po')
            data_files.append(('share/locale/' + name[:-3] + '/LC_MESSAGES', ['build/locale/' + name[:-3] + '/startupmanager.mo']))
            os.system('xml2po -p po/' + name + ' data/startupmanager.xml > build/doc/' + name[:-3] + '/startupmanager.xml')
            data_files.append(('share/gnome/help/startupmanager/' + name[:-3] + '/', ['build/doc/' + name[:-3] + '/startupmanager.xml']))

setup(
    name = 'startupmanager',
    version = '1.9.12',
    description = 'Configure boot settings',
    author = 'Jimmy Rönnholm',
    author_email = 'jimmy.ronnholm@telia.com',
    url = 'http://web.telia.com/~u88005282/sum/',
    packages = ['bootconfig'],
    data_files = data_files,
    license = 'MIT',
    platforms = 'posix',
    )

if sys.argv[1] == 'clean':
    for root, dirs, files in os.walk('build', topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))
    if os.path.isdir('build'):
        os.rmdir('build')
