#include "stdebug.h"

#include <signal.h>
#include <stdlib.h>
#include <unistd.h>

int alarm_expired;

void
start_alarm(int n)
{
  alarm_expired=0;
  alarm(n);
}

void
end_alarm(void)
{
  alarm(0);
}

int
check_alarm(void)
{
  return alarm_expired;
}

void
signal_alarm(int signum)
{
  alarm_expired=1;
}

void
init_alarm(void)
{
  struct sigaction sa;

  sa.sa_handler = signal_alarm;
  sigemptyset(&sa.sa_mask);
  sa.sa_flags = 0;
  if (sigaction(SIGALRM,&sa,NULL) != 0)
    die("Error setting up alarm signal:");
}
