.TH starconvert "1" "Nov 2002"
.SH NAME
starconvert \- convert text data files to StarPlot format
.SH SYNOPSIS
.B starconvert
.I spec\-file input\-file
.RI "[ " output\-file " ]"
.br
.
.SH DESCRIPTION
.PP
Although many stellar data files are publicly available on the Internet from
NASA and other astronomical organizations, there is no set format for these
files.  The program starconvert acts as a buffer between this confusion and
the format in which StarPlot requires data files.  To do so, it uses a
specification file that details how various fields of stellar data (name,
distance, right ascension, etc.) may be extracted from the original data file.
.
.PP
On the StarPlot web site are available some packages of data that include
both an original data file from NASA, and also a  specification file.
These packages are referred to as "data sets", from which starconvert can
produce a data file in StarPlot format.  For ease of use, this should be
done via the
.BR starpkg (1)
shell script.
.
.PP
The starconvert command uses the specifications in
.I spec\-file
to convert
.I input\-file
to StarPlot data format and writes the results to
.I output\-file
if specified, or standard output if not.  The first two arguments are required.
Exactly ONE may be replaced with a dash `\-' for reading from standard input.
.
.SH SPECIFICATION FILES
.
.PP
For detailed information on how to write a specification file, see
the example file listed below.  Be aware that I expect to change the default
format of starconvert spec files after version 1.0, although starconvert will
remain backwards\-compatible.
.br
.
.SH FILES
.br
.I DOCDIR/
\- Contains documentation
.br
.I DOCDIR/examples/example.spec
\- Example specification file
.SH SEE ALSO
.BR starplot "(1), " starpkg (1)
.SH AUTHOR
.nh
.PP
Copyright \(co 2000\-2002 under the GNU GPL by Kevin B. McCarty 
.IR <kmccarty@princeton.edu> .
The StarPlot web page is at
.IR www.starplot.org .
