#===================================
#           select_user
#  Copyright 2010 - Nathan Osman
#
#   A small helper to StackApplet
#
#   StackApplet is released under
#        the MIT license
#===================================

# Once again, we need GTK for this

import pygtk
pygtk.require('2.0')  # make sure we have pyGTK 2+
import gtk
import gobject

# If we're going to fetch lists of users,
# we need our api request module

import api_request

class SelectUserDialog(gtk.Dialog):

	def __init__(self,site_endpoint):
	
		gtk.Dialog.__init__(self,"Find User",flags=gtk.DIALOG_MODAL)
		
		self.site = site_endpoint
		
		# We want to create a window like this:
		#
		#  ____________________
		# | Name               |
		# | ================== |
		# |            [Search]|
		# | ------------------ |
		# | ------------------ |
		# |            [Select]|
		# |____________________|
		#
		
		self.vbox.set_spacing(8)
		
		label1 = gtk.Label()
		label1.set_text("Please enter part of your username:")
		label1.show()
		self.edit1 = gtk.Entry()
		self.edit1.show()
		
		button1 = gtk.Button()
		button1.set_label("Search")
		button1.connect("button_press_event", self.DoSearch)
		button1.show()
		
		self.vbox.pack_start(label1)
		self.vbox.pack_start(self.edit1)
		self.vbox.pack_start(button1,False)
		
		# Now we need a listview
		
		self.user_list = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
		
		self.treeview1 = gtk.TreeView()
		self.treeview1.set_model(self.user_list)
		
		column1 = gtk.TreeViewColumn()
		cell1 = gtk.CellRendererText()
		column1.pack_start(cell1)
		column1.add_attribute(cell1,'text',0)
		column1.set_title("Username:")
		column1.set_min_width(145)
		
		column2 = gtk.TreeViewColumn()
		cell2 = gtk.CellRendererText()
		column2.pack_start(cell2)
		column2.add_attribute(cell2,'text',1)
		column2.set_title("Rep.:")
		
		self.treeview1.append_column(column1)
		self.treeview1.append_column(column2)
		self.treeview1.show()
		
		scrollwindow1 = gtk.ScrolledWindow()
		scrollwindow1.add_with_viewport(self.treeview1)
		scrollwindow1.show()
		scrollwindow1.set_size_request(180,200)
		self.vbox.pack_start(scrollwindow1)
		
		button2 = gtk.Button()
		button2.set_label("Select")
		button2.show()
		button2.connect("button_press_event", self.DoAccept)
		
		button3 = gtk.Button()
		button3.set_label("Cancel")
		button3.show()
		button3.connect("button_press_event", self.DoCancel)
		
		self.action_area.pack_start(button2)
		self.action_area.pack_start(button3)
		
		self.set_border_width(10)
		
		self.ret_val = 0
		
	def DoSearch(self,widget,event):
		
		# We need to do the search now...
		
		self.user_list.clear()
		
		try:
			users = api_request.GetJSONData(self.site + "/1.0/users?filter=" + self.edit1.get_text() + "&key=_qlxmEAOH06hLA1_FsZIGQ")
		
			for user in users["users"]:
		
				self.user_list.append([user["display_name"],user["reputation"],user["user_id"]])
		
		except Exception as e:
		
			# Should definitely display an error...
			# but it doesn't yet
			
			pass
	
	def DoAccept(self,widget,event):
	
		self.ret_val = self.user_list[self.treeview1.get_selection().get_selected()[1]][2]
		
		self.destroy()
	
	def DoCancel(self,widget,event):
		
		self.destroy()
