#===================================
#          api_request
#  Copyright 2010 - Nathan Osman
#
#   A small helper to StackApplet
#
#   StackApplet is released under
#        the MIT license
#===================================

# required modules

import urllib2
import zlib    # for handling GZIP compression

# Now lets see if we can import the JSON
# module. We're going to make two tries at this
# to make sure we get one:

try:
    import json
except ImportError:
    import simplejson as json

def GetJSONData(url):
	
	# Create the request
	request  = urllib2.Request(url)
	request.add_header('Accept-Encoding', 'gzip,deflate')    # Required by the API
	
	opener = urllib2.build_opener()
	
	# Get the raw stream and decompress it
	
	gzipped_stream = opener.open(request)
	raw_data = zlib.decompress(gzipped_stream.read(), 16+zlib.MAX_WBITS)
	
	# parse the json
	json_data = json.loads(raw_data)
	
	return json_data
