#===================================
#         setting_store
#  Copyright 2010 - Nathan Osman
#
#   A small helper to StackApplet
#
#   StackApplet is released under
#        the MIT license
#===================================

# Now lets see if we can import the JSON
# module. We're going to make two tries at this
# to make sure we get one:

import os

try:
    import json
except ImportError:
    import simplejson as json

class SettingStore:
	
	def __init__(self):
	
		self.data = {}
	
	# We really only need four functions:
	#  - for loading and saving
	#  - for setting and getting
	
	def Load(self):
		
		# Open the file first...
		
		try:
			f = open(os.path.join(os.getenv("HOME"),".stackapplet"),'r')
			
			self.data = json.loads(f.readline())
			
			f.close()
			
		except Exception,e:
		
			# If there is a problem (like the file
			# can't be opened) just skip it  :)
			
			pass
	
	def Save(self):
	
		f = open(os.path.join(os.getenv("HOME"),".stackapplet"),'w')
		
		f.write(json.dumps(self.data))
		
		f.close()
		
	def Get(self,name,default):
		
		if name in self.data:
			return self.data[name]
		else:
			self.data[name] = default
			return default;
		
	def Set(self,name,value):
		
		self.data[name] = value
