#===================================
#         setting_dialog
#  Copyright 2010 - Nathan Osman
#
#   A small helper to StackApplet
#
#   StackApplet is released under
#        the MIT license
#===================================

# Well, we obviously need GTK for this

import pygtk
pygtk.require('2.0')  # make sure we have pyGTK 2+
import gtk
import gobject

# Let's also use our SettingStore class too!

import setting_store

#======================
# the class definition
#======================

class SettingDialog(gobject.GObject):

	def __init__(self):
	
		self.__gobject_init__()
		
		# First things first - top-level window
		self.main = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.main.set_title("StackApplet Settings")
		self.main.connect("delete_event", self.main.hide_on_delete)
		
		# Second, we divide the area as follows:
		#  ____________________
		# |    |               |
		# |    |               |
		# |    |               |
		# |____|_______________|
		# |____________________|
		#
		
		# For the top and bottom
		vbox = gtk.VBox(False,5)
		
		# For the left and right on the top one
		hbox = gtk.HBox(False,5)
		
		site_list_box = gtk.VBox(False,3)
		
		self.site_model = gtk.ListStore(gobject.TYPE_STRING)
		
		settings = setting_store.SettingStore()
		settings.Load()
		sites = settings.Get("DesiredSites","stackoverflow/1").split()
		
		for site in sites:
			site_data = site.split('/')
			
			self.site_model.append([site_data[0] + " - " + site_data[1]])
		
		self.site_list = gtk.TreeView()
		self.site_list.set_model(self.site_model)
		
		column = gtk.TreeViewColumn()
		cell = gtk.CellRendererText()
		column.pack_start(cell)
		column.add_attribute(cell,'text',0)
		self.site_list.append_column(column)
		
		column.set_title("Sites:")
		
		self.site_list.set_size_request(200,400)
		
		delete = gtk.Button()
		delete.set_label("Remove")
		delete.connect("button_press_event", self.DeleteItem)
		
		site_list_box.add(self.site_list)
		site_list_box.add(delete)
		
		# The labels
		
		right_side_box = gtk.VBox(False,3)
		
		label_box = gtk.VBox(False,3)
		
		label1 = gtk.Label()
		label1.set_text("Please enter the site name: [eg. 'stackoverflow']")
		self.edit1 = gtk.Entry()
		
		label2 = gtk.Label()
		label2.set_text("Please enter your user id for that site:")
		self.edit2 = gtk.Entry()
		
		button = gtk.Button()
		button.set_label("Add to list")
		button.connect("button_press_event", self.AddItem)
		
		label_box.pack_start(label1,expand=False)
		label_box.pack_start(self.edit1,expand=False)
		label_box.pack_start(label2,expand=False)
		label_box.pack_start(self.edit2,expand=False)
		label_box.pack_start(button,expand=False)
		
		label_box.set_border_width(15)
		
		global_box = gtk.VBox(False,3)
		
		label3 = gtk.Label()
		label3.set_text("Refresh rate: [in seconds]")
		self.edit3 = gtk.Entry()
		rate = settings.Get("RefreshRate",300000)
		self.edit3.set_text(str(int(rate) / 1000))
		
		self.check1 = gtk.CheckButton(label="Show username")
		
		if settings.Get("ShowNames","true") == "true":
			self.check1.set_active(True)
		
		global_box.pack_end(self.check1,expand=False)
		global_box.pack_end(self.edit3,expand=False)
		global_box.pack_end(label3,expand=False)
		
		global_box.set_border_width(15)
		
		right_side_box.add(label_box)
		right_side_box.add(global_box)
		
		hbox.add(site_list_box)
		hbox.add(right_side_box)
		
		# The okay and cancel buttons
		
		ok = gtk.Button();
		ok.set_label("OK")
		cancel = gtk.Button();
		cancel.set_label("Cancel")
		
		ok.connect("button_press_event", self.OK)
		cancel.connect("button_press_event", self.Cancel)
		
		button_box = gtk.HBox(True,10)
		button_box.pack_start(ok,expand=False)
		button_box.pack_start(cancel,expand=False)
		
		vbox.add(hbox)
		vbox.add(button_box)
		
		vbox.set_border_width(8)
		
		vbox.show_all()
		
		self.main.add(vbox)
	
	def OK(self,widget,event):
		
		# Challenge, challenge!
		# We need to deserialize the list!
		
		total_items = []
		
		for site in self.site_model:
			(site_name,site_id) = site[0].split(' - ')
			
			total_items.append(site_name + "/" + site_id)
		
		display_sites = " ".join(total_items)
		
		settings = setting_store.SettingStore()
		
		settings.Load()
		settings.Set("DesiredSites",display_sites)
		settings.Set("RefreshRate",int(self.edit3.get_text()) * 1000)
		if self.check1.get_active() == True:
			settings.Set("ShowNames","true")
		else:
			settings.Set("ShowNames","false")
		settings.Save()
		
		self.main.hide()
		
		self.emit("new_settings")
		
	def Cancel(self,widget,event):
		# basically do nothing!
		
		self.main.hide()
	
	def Display(self):
		self.main.show()
	
	def AddItem(self,widget,event):
		self.site_model.append([self.edit1.get_text() + " - " + self.edit2.get_text()])
	
	def DeleteItem(self,widget,event):
	
		self.site_model.remove(self.site_list.get_selection().get_selected()[1])


gobject.signal_new("new_settings", SettingDialog,
                                   gobject.SIGNAL_RUN_FIRST,
                                   gobject.TYPE_NONE,
                                   ())
